/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.php.SaasClientPhpAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.php.util.PhpUtil;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class CustomClientPhpCodeGenerator
extends SaasClientCodeGenerator {
    private FileObject saasServiceFile = null;
    private FileObject serviceFolder = null;
    private FileObject saasFolder = null;
    private SaasClientPhpAuthenticationGenerator authGen;

    public CustomClientPhpCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.PHP);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        return SaasBean.canAccept((SaasMethod)method, CustomSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && PhpUtil.isPhp(doc);
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        this.init(m, new CustomClientSaasBean((CustomSaasMethod)m, true), doc);
    }

    public void init(SaasMethod m, CustomClientSaasBean saasBean, Document doc) throws IOException {
        super.init(m, doc);
        this.setBean((SaasBean)saasBean);
        this.serviceFolder = null;
        this.saasFolder = null;
        this.authGen = new SaasClientPhpAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(CustomClientSaasBean.getProfile((SaasMethod)m, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public CustomClientSaasBean getBean() {
        return (CustomClientSaasBean)super.getBean();
    }

    public SaasClientPhpAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            FileObject rootFolder = this.getSourceRootFolder();
            String folderName = this.getBean().getSaasServicePackageName().replace(".", "_");
            this.serviceFolder = rootFolder.getFileObject(folderName);
            if (this.serviceFolder == null) {
                this.serviceFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
        }
        return this.serviceFolder;
    }

    public FileObject getSaasFolder() throws IOException {
        if (this.saasFolder == null) {
            FileObject rootFolder = this.getSourceRootFolder();
            String folderName = "org.netbeans.saas".replace(".", "_");
            this.saasFolder = rootFolder.getFileObject(folderName);
            if (this.saasFolder == null) {
                this.saasFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
        }
        return this.saasFolder;
    }

    private FileObject getSourceRootFolder() {
        Sources sources = ProjectUtils.getSources((Project)this.getProject());
        SourceGroup[] groups = sources.getSourceGroups("PHPSOURCE");
        FileObject rootFolder = this.getProject().getProjectDirectory();
        if (groups != null && groups.length > 0 && groups[0] != null && groups[0].getRootFolder() != null) {
            rootFolder = groups[0].getRootFolder();
        }
        return rootFolder;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptyList());
    }

    protected void preGenerate() throws IOException {
        this.createRestConnectionFile(this.getProject());
        this.getTargetFolder().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Map templates = CustomClientPhpCodeGenerator.this.getBean().getArtifactTemplates(Constants.DropFileType.PHP.prefix());
                for (Map.Entry e : templates.entrySet()) {
                    String id = (String)e.getKey();
                    String template = (String)e.getValue();
                    Util.createDataObjectFromTemplate((String)template, (FileObject)CustomClientPhpCodeGenerator.this.getSaasServiceFolder(), (String)id);
                }
            }
        });
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestConnection.php", (FileObject)this.getSaasFolder(), null);
        Util.createDataObjectFromTemplate((String)"Templates/SaaSServices/RestResponse.php", (FileObject)this.getSaasFolder(), null);
    }

    protected String getFixedParameterDeclaration() {
        String fixedCode = "";
        List inputParams = this.getBean().getInputParameters();
        List signParams = null;
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            signParams = sessionKey.getParameters();
        } else {
            signParams = Collections.emptyList();
        }
        for (ParameterInfo param : this.getBean().getInputParameters()) {
            if (!param.isFixed() || Util.isContains((ParameterInfo)param, (List)signParams)) continue;
            fixedCode = fixedCode + "$" + this.getVariableName(param.getName()) + " = $" + PhpUtil.findParamValue(param) + ";\n";
        }
        return fixedCode;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getBean().getSaasServicePackageName() + "->" + this.getBean().getSaasServiceName());
        imports.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.getTargetFile(), imports);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.netbeans.saas->RestConnection");
        imports.add("org.netbeans.saas->RestResponse");
        this.addImportsToPhp(this.saasServiceFile, imports);
    }

    protected void insertSaasServiceAccessCode(boolean isInBlock) throws IOException {
        try {
            String inclStr = "\ninclude_once \"" + this.getSaasServiceFolder().getName() + "/" + this.getBean().getSaasServiceName() + ".php\";\n";
            String code = PhpUtil.wrapWithTag(inclStr + this.getCustomMethodBody(), this.getTargetDocument(), this.getStartPosition()) + "\n";
            this.insert(code, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public ParameterInfo findParameter(String name) {
        List params = this.getBean().getInputParameters();
        if (params != null) {
            for (ParameterInfo param : params) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params, String indent) {
        if (indent == null) {
            indent = " ";
        }
        String paramDecl = "";
        for (ParameterInfo param : params) {
            String name = this.getVariableName(param.getName());
            String paramVal = PhpUtil.findParamValue(param);
            if (param.getType() != String.class) {
                paramDecl = paramDecl + indent + "$" + name + " = " + paramVal + ";\n";
                continue;
            }
            if (paramVal != null) {
                paramDecl = paramDecl + indent + "$" + name + " = \"" + paramVal + "\";\n";
                continue;
            }
            paramDecl = paramDecl + indent + "$" + name + " = null;\n";
        }
        return paramDecl;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params) {
        String indent = "                 ";
        return this.getHeaderOrParameterDeclaration(params, indent);
    }

    private void addImportsToPhp(FileObject saasServiceFile, List<String> imports) {
    }

    protected String getCustomMethodBody() throws IOException {
        String paramUse = "";
        String paramDecl = "";
        String indent2 = "                    ";
        List<ParameterInfo> filterParams = this.getServiceMethodParameters();
        paramUse = paramUse + CustomClientPhpCodeGenerator.getHeaderOrParameterUsage(filterParams);
        paramDecl = paramDecl + this.getHeaderOrParameterDeclaration(filterParams);
        String methodBody = "";
        methodBody = methodBody + indent2 + "try {\n";
        methodBody = methodBody + paramDecl + "\n";
        methodBody = methodBody + indent2 + "$result = " + this.getBean().getSaasServiceName() + "::" + this.getBean().getSaasServiceMethodName() + "(" + paramUse + ");\n";
        methodBody = methodBody + indent2 + "echo $result->getResponseBody();\n";
        methodBody = methodBody + indent2 + "} catch(Exception $e) {\n";
        methodBody = methodBody + indent2 + "    echo \"Exception occured: \".$e;\n";
        methodBody = methodBody + indent2 + "}\n";
        return methodBody;
    }

    public static String getHeaderOrParameterUsage(List<ParameterInfo> params) {
        String paramUsage = "";
        for (ParameterInfo param : params) {
            String name = Util.getParameterName((ParameterInfo)param, (boolean)true, (boolean)true, (boolean)true);
            paramUsage = paramUsage + "$" + name + ", ";
        }
        if (params.size() > 0) {
            paramUsage = paramUsage.substring(0, paramUsage.length() - 2);
        }
        return paramUsage;
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> params, String varName, boolean evaluate) {
        StringBuffer sb = new StringBuffer();
        for (ParameterInfo param : params) {
            sb.append(CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(param, varName, evaluate || param.isApiKey()));
        }
        return sb.toString();
    }

    public static String getHeaderOrParameterDefinitionPart(ParameterInfo param, String varName, boolean evaluate) {
        StringBuffer sb = new StringBuffer();
        String paramName = Util.getParameterName((ParameterInfo)param);
        String paramVal = null;
        String indent = "             ";
        if (evaluate) {
            paramVal = PhpUtil.findParamValue(param);
            if (param.getType() != String.class) {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + paramVal + ";\n");
            } else if (paramVal != null) {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + paramVal + ";\n");
            } else {
                sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = null;\n");
            }
        } else if (param.getType() != String.class) {
            sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + Util.getVariableName((String)param.getName()) + ";\n");
        } else {
            sb.append(indent + "$" + varName + "[\"" + paramName + "\"] = $" + Util.getVariableName((String)param.getName()) + ";\n");
        }
        return sb.toString();
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate) {
        String paramCode = "";
        paramCode = paramCode + "$" + varName + " = array();\n";
        paramCode = paramCode + CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(params, varName, evaluate) + "\n";
        return paramCode;
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate, Constants.HttpMethodType httpMethod) {
        String part = CustomClientPhpCodeGenerator.getHeaderOrParameterDefinitionPart(params, varName, evaluate);
        if (!(httpMethod != Constants.HttpMethodType.PUT && httpMethod != Constants.HttpMethodType.POST || Util.isContains(params, (ParameterInfo)new ParameterInfo("Content-Type", String.class)))) {
            part = part + ", array(\"Content-Type\" => " + Util.getVariableName((String)"Content-Type") + ")";
        }
        String paramCode = "";
        paramCode = paramCode + "$" + varName + " = array();\n";
        paramCode = paramCode + part + "\n";
        return paramCode;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List params = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethod = this.getBean().getHttpMethod();
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            ParameterInfo contentTypeParam = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class contentType = InputStream.class;
            if (contentTypeParam == null) {
                params.add(new ParameterInfo("Content-Type", String.class));
            } else if (!contentTypeParam.isFixed() && !params.contains(contentTypeParam)) {
                params.add(contentTypeParam);
            } else {
                String value = Util.findParamValue((ParameterInfo)contentTypeParam);
                if (value.equals("text/plain") || value.equals("application/xml") || value.equals("text/xml")) {
                    contentType = String.class;
                }
            }
            params.add(new ParameterInfo("content", contentType));
        }
        return params;
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        params.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return params;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(CustomClientSaasBean bean) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.addAll(CustomClientPhpCodeGenerator.getAuthenticatorMethodParametersForWeb());
        params.addAll(bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return params;
    }
}

