/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.common.SecurityRoleMapping;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.PrincipalTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.SRMBaseTableModel;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;

public class SRMPrincipalTableModel
extends SRMBaseTableModel
implements PrincipalTableModel {
    private final int numColumns;

    public SRMPrincipalTableModel(XmlMultiViewDataSynchronizer s, SecurityRoleMapping m, int columns) {
        super(s, m);
        this.numColumns = columns;
    }

    @Override
    public int addElement(PrincipalNameMapping entry) {
        int index = this.mapping.addPrincipalName(entry.getPrincipalName());
        try {
            this.mapping.setPrincipalNameClassName(index, entry.getClassName());
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
        this.fireTableRowsInserted(index, index);
        this.modelUpdatedFromUI();
        return index;
    }

    @Override
    public int replaceElement(PrincipalNameMapping oldEntry, PrincipalNameMapping newEntry) {
        int index = this.indexOf(oldEntry);
        if (index != -1) {
            this.mapping.setPrincipalName(index, newEntry.getPrincipalName());
            try {
                this.mapping.setPrincipalNameClassName(index, newEntry.getClassName());
            }
            catch (VersionNotSupportedException ex) {
                // empty catch block
            }
            this.fireTableRowsUpdated(index, index);
            this.modelUpdatedFromUI();
        }
        return index;
    }

    @Override
    public int removeElement(PrincipalNameMapping entry) {
        int index = this.indexOf(entry);
        if (index != -1) {
            this.mapping.removePrincipalName(entry.getPrincipalName());
            this.modelUpdatedFromUI();
        }
        return index;
    }

    public void removeElementAt(int index) {
        if (index >= 0 || index < this.mapping.sizePrincipalName()) {
            this.mapping.removeValue("PrincipalName", index);
            this.fireTableDataChanged();
            this.modelUpdatedFromUI();
        }
    }

    @Override
    public void removeElements(int[] indices) {
        if (indices.length > 0) {
            boolean dataChanged = false;
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] < 0 && indices[i] >= this.mapping.sizePrincipalName()) continue;
                this.mapping.removeValue("PrincipalName", indices[i]);
                dataChanged = true;
            }
            if (dataChanged) {
                this.fireTableDataChanged();
                this.modelUpdatedFromUI();
            }
        }
    }

    @Override
    public boolean contains(PrincipalNameMapping entry) {
        return this.indexOf(entry) != -1;
    }

    @Override
    public PrincipalNameMapping getElementAt(int rowIndex) {
        PrincipalNameMapping result = null;
        if (rowIndex >= 0 && rowIndex < this.mapping.sizePrincipalName()) {
            try {
                result = new PrincipalNameMapping(this.mapping.getPrincipalName(rowIndex), this.mapping.getPrincipalNameClassName(rowIndex));
            }
            catch (VersionNotSupportedException ex) {
                result = new PrincipalNameMapping(this.mapping.getPrincipalName(rowIndex));
            }
            this.modelUpdatedFromUI();
        }
        return result;
    }

    private int indexOf(PrincipalNameMapping entry) {
        String[] names = this.mapping.getPrincipalName();
        if (names != null) {
            for (int index = 0; index < names.length; ++index) {
                if (!Utils.strEquivalent(names[index], entry.getPrincipalName())) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = null;
        if (rowIndex >= 0 && rowIndex < this.mapping.sizePrincipalName() && columnIndex >= 0 && columnIndex < this.numColumns) {
            if (columnIndex == 0) {
                result = this.mapping.getPrincipalName(rowIndex);
            } else {
                try {
                    result = this.mapping.getPrincipalNameClassName(rowIndex);
                }
                catch (VersionNotSupportedException ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.mapping.sizePrincipalName();
    }

    @Override
    public int getColumnCount() {
        return this.numColumns;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.customizerBundle.getString("LBL_PrincipalName");
            }
            case 1: {
                return this.customizerBundle.getString("LBL_ClassName");
            }
        }
        return null;
    }
}

