/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class SunDescriptorDataNode
extends DataNode {
    private static final String SUN_DD = "sundd";
    private SunDescriptorDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public SunDescriptorDataNode(SunDescriptorDataObject sunDescriptorDataObject) {
        this(sunDescriptorDataObject, Children.LEAF);
    }

    public SunDescriptorDataNode(SunDescriptorDataObject sunDescriptorDataObject, Children children) {
        super((DataObject)sunDescriptorDataObject, children);
        this.dataObject = sunDescriptorDataObject;
        this.initListeners();
        this.setIconBase(this.dataObject.getSaxError() == null);
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if ("documentDTD".equals(string)) {
                    SunDescriptorDataNode.this.firePropertyChange(SunDescriptorDataNode.PROPERTY_DOCUMENT_TYPE, object, object2);
                } else if ("valid".equals(string) && Boolean.TRUE.equals(object2)) {
                    SunDescriptorDataNode.this.removePropertyChangeListener(SunDescriptorDataNode.this.ddListener);
                } else if ("document_valid".equals(string)) {
                    SunDescriptorDataNode.this.setIconBase(Boolean.TRUE.equals(object2));
                } else if ("propertySets".equals(string)) {
                    SunDescriptorDataNode.this.firePropertySetsChange(null, null);
                } else if ("sax_error".equals(string)) {
                    SunDescriptorDataNode.this.fireShortDescriptionChange((String)object, (String)object2);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private void setIconBase(boolean bl) {
        if (bl) {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        } else {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForInvalidDocument());
        }
        this.fireIconChange();
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName(SUN_DD);
        set.setDisplayName(NbBundle.getMessage(SunDescriptorDataNode.class, (String)"PROP_deploymentSet"));
        set.setShortDescription(NbBundle.getMessage(SunDescriptorDataNode.class, (String)"HINT_deploymentSet"));
        set.setValue("helpID", (Object)"TBD: sun-dd node");
        sheet.put(set);
        return sheet;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int n) {
        String string = this.dataObject.getIconBaseForValidDocument();
        Image image = ImageUtilities.loadImage((String)(string + ".gif"));
        if (this.dataObject.getSaxError() == null) {
            return image;
        }
        Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/sun/ddloaders/resources/ErrorBadge.gif");
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)6, (int)6);
    }

    public String getShortDescription() {
        SAXException sAXException = this.dataObject.getSaxError();
        if (sAXException == null) {
            return NbBundle.getMessage(SunDescriptorDataNode.class, (String)"LBL_NodeShortDescription");
        }
        return sAXException.getMessage();
    }
}

