/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.CompileAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JavaOutputListenerProvider
implements OutputProcessor {
    private static final String[] JAVAGOALS = new String[]{"mojo-execute#compiler:compile", "mojo-execute#compiler:testCompile"};
    private Pattern failPattern = Pattern.compile("\\s*(?:\\[WARNING\\])?(?:\\[javac\\])?(?:Compilation failure)?\\s*(.*)\\.java\\:\\[([0-9]*),([0-9]*)\\] (.*)", 32);

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.failPattern.matcher(line);
        if (match.matches()) {
            Sources srcs;
            Project prj;
            String clazz = match.group(1);
            String lineNum = match.group(2);
            String text = match.group(4);
            File clazzfile = FileUtil.normalizeFile((File)new File(clazz + ".java"));
            visitor.setOutputListener(new CompileAnnotation(clazzfile, lineNum, text), text.indexOf("[deprecation]") < 0);
            FileUtil.refreshFor((File[])new File[]{clazzfile});
            FileObject file = FileUtil.toFileObject((File)clazzfile);
            String newclazz = clazz;
            if (file != null && (prj = FileOwnerQuery.getOwner((FileObject)file)) != null && (srcs = (Sources)prj.getLookup().lookup(Sources.class)) != null) {
                for (SourceGroup grp : srcs.getSourceGroups("java")) {
                    if (!FileUtil.isParentOf((FileObject)grp.getRootFolder(), (FileObject)file) || !(newclazz = FileUtil.getRelativePath((FileObject)grp.getRootFolder(), (FileObject)file)).endsWith(".java")) continue;
                    newclazz = newclazz.substring(0, newclazz.length() - ".java".length());
                }
            }
            line = line.replace(clazz, newclazz);
            visitor.setLine(line);
        }
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return JAVAGOALS;
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }
}

