/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Vector;

public class TypeMethod {
    Type[] args;
    Type res;

    TypeMethod() {
    }

    TypeMethod(Type type) {
        this.args = new Type[0];
        this.res = type;
    }

    TypeMethod(Type type, Type type2) {
        this.args = new Type[1];
        this.args[0] = type;
        this.res = type2;
    }

    TypeMethod(Type type, Type type2, Type type3) {
        this.args = new Type[2];
        this.args[0] = type;
        this.args[1] = type2;
        this.res = type3;
    }

    TypeMethod(Type type, Type type2, Type type3, Type type4) {
        this.args = new Type[3];
        this.args[0] = type;
        this.args[1] = type2;
        this.args[2] = type3;
        this.res = type4;
    }

    int argumentsWordSize() {
        return this.args.length;
    }

    static TypeMethod parseCap(Safeptr safeptr) {
        int n;
        Vector<Type> vector = new Vector<Type>(4);
        int n2 = safeptr.u1(0);
        Safeptr safeptr2 = safeptr.offset(1);
        Type type = null;
        block13: for (n = 0; n < n2; ++n) {
            if (type != null) {
                vector.add(type);
                if (type.equals(Type.Int)) {
                    vector.add(Type.Int2);
                }
                type = null;
            }
            switch (safeptr2.nibble(n)) {
                case 1: {
                    type = Type.Void;
                    continue block13;
                }
                case 2: {
                    type = Type.Boolean;
                    continue block13;
                }
                case 3: {
                    type = Type.Byte;
                    continue block13;
                }
                case 4: {
                    type = Type.Short;
                    continue block13;
                }
                case 5: {
                    type = Type.Int;
                    continue block13;
                }
                case 6: {
                    int n3 = safeptr2.nibble(n + 1) << 12 | safeptr2.nibble(n + 2) << 8 | safeptr2.nibble(n + 3) << 4 | safeptr2.nibble(n + 4);
                    Classref.check(n3);
                    type = new TypeClass(n3);
                    n += 4;
                    continue block13;
                }
                case 10: {
                    type = Type.BooleanArray;
                    continue block13;
                }
                case 11: {
                    type = Type.ByteArray;
                    continue block13;
                }
                case 12: {
                    type = Type.ShortArray;
                    continue block13;
                }
                case 13: {
                    type = Type.IntArray;
                    continue block13;
                }
                case 14: {
                    int n3 = safeptr2.nibble(n + 1) << 12 | safeptr2.nibble(n + 2) << 8 | safeptr2.nibble(n + 3) << 4 | safeptr2.nibble(n + 4);
                    Classref.check(n3);
                    type = new TypeArray(new TypeClass(n3));
                    n += 4;
                    continue block13;
                }
                default: {
                    throw new VerifierError("TypeMethod.1", safeptr2.nibble(n), (Object)safeptr);
                }
            }
        }
        if (n > n2) {
            throw new VerifierError("TypeMethod.2", safeptr);
        }
        if (type == null) {
            throw new VerifierError("TypeMethod.3", safeptr);
        }
        TypeMethod typeMethod = new TypeMethod();
        typeMethod.res = type;
        typeMethod.args = new Type[vector.size()];
        for (n = 0; n < typeMethod.args.length; ++n) {
            typeMethod.args[n] = (Type)vector.elementAt(n);
            if (typeMethod.args[n].equals(Type.Void)) {
                throw new VerifierError("TypeMethod.4", safeptr);
            }
            if (!typeMethod.args[n].equals(Type.Int) && !typeMethod.args[n].equals(Type.IntArray)) continue;
            Cap.Header.useInts();
        }
        return typeMethod;
    }

    public static TypeMethod parseExport(String string) {
        int n;
        Vector<Type> vector = new Vector<Type>(4);
        Type type = null;
        block17: for (n = 0; n < string.length(); ++n) {
            if (type != null) {
                vector.add(type);
                if (type.equals(Type.Int)) {
                    vector.add(Type.Int2);
                }
                type = null;
            }
            switch (string.charAt(n)) {
                case 'B': {
                    type = Type.Byte;
                    continue block17;
                }
                case 'I': {
                    type = Type.Int;
                    continue block17;
                }
                case 'L': {
                    int n2 = string.indexOf(59, n + 1);
                    if (n2 == -1) {
                        throw new VerifierError("TypeMethod.5", string);
                    }
                    int n3 = Classref.refForName(string.substring(n + 1, n2));
                    type = new TypeClass(n3);
                    n = n2;
                    continue block17;
                }
                case 'S': {
                    type = Type.Short;
                    continue block17;
                }
                case 'Z': {
                    type = Type.Boolean;
                    continue block17;
                }
                case '[': {
                    int n3;
                    int n2;
                    switch (string.charAt(++n)) {
                        case 'B': {
                            type = Type.ByteArray;
                            continue block17;
                        }
                        case 'I': {
                            type = Type.IntArray;
                            continue block17;
                        }
                        case 'L': {
                            n2 = string.indexOf(59, n + 1);
                            if (n2 == -1) {
                                throw new VerifierError("TypeMethod.6", string);
                            }
                            n3 = Classref.refForName(string.substring(n + 1, n2));
                            type = new TypeArray(new TypeClass(n3));
                            n = n2;
                            continue block17;
                        }
                        case 'S': {
                            type = Type.ShortArray;
                            continue block17;
                        }
                        case 'Z': {
                            type = Type.BooleanArray;
                            continue block17;
                        }
                    }
                    throw new VerifierError("TypeMethod.7", (Object)string.substring(n, n + 1), (Object)string);
                }
                case 'V': {
                    type = Type.Void;
                    continue block17;
                }
                case '(': 
                case ')': {
                    continue block17;
                }
                default: {
                    throw new VerifierError("TypeMethod.8", (Object)string.substring(n, n + 1), (Object)string);
                }
            }
        }
        if (type == null) {
            throw new VerifierError("TypeMethod.9", string);
        }
        TypeMethod typeMethod = new TypeMethod();
        typeMethod.res = type;
        typeMethod.args = new Type[vector.size()];
        for (n = 0; n < typeMethod.args.length; ++n) {
            typeMethod.args[n] = (Type)vector.elementAt(n);
            if (!typeMethod.args[n].equals(Type.Void)) continue;
            throw new VerifierError("TypeMethod.10", string);
        }
        return typeMethod;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TypeMethod)) {
            return false;
        }
        TypeMethod typeMethod = (TypeMethod)object;
        if (typeMethod.args.length != this.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (typeMethod.args[i].equals(this.args[i])) continue;
            return false;
        }
        return typeMethod.res.equals(this.res);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.res.toString());
        stringBuffer.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.args[i].toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

