/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowBadgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;

public abstract class FlowNodeBadgePresenter
extends FlowPresenter
implements FlowPresenter.FlowUIResolver {
    private FlowNodeDescriptor node = null;
    private FlowBadgeDescriptor badge = null;
    private FlowNodeDescriptor oldNode;
    private boolean removeAdd;

    @Override
    public final void resolveRemoveBadge() {
        FlowBadgeDescriptor newBadge;
        FlowNodeDescriptor newNode;
        FlowScene scene = this.getScene();
        if (this.isVisible()) {
            newNode = this.getNodeDescriptor();
            newBadge = newNode != null ? this.getPinBadgeDescriptor() : null;
        } else {
            newNode = null;
            newBadge = null;
        }
        boolean bl = this.removeAdd = !FlowNodeBadgePresenter.equals(this.node, newNode) || !FlowNodeBadgePresenter.equals(this.badge, newBadge);
        if (this.removeAdd) {
            if (this.badge != null) {
                scene.removeBadge(this.node, this.badge);
                scene.unregisterUI(this.badge, (FlowPresenter.FlowUIResolver)this);
            }
            this.oldNode = this.node;
            this.node = newNode;
            this.badge = newBadge;
        } else {
            this.oldNode = null;
        }
    }

    @Override
    public final void resolveRemoveEdge() {
    }

    @Override
    public final void resolveRemovePin() {
    }

    @Override
    public final void resolveRemoveNode() {
    }

    @Override
    public final void resolveAddNode() {
    }

    @Override
    public final void resolveAddPin() {
    }

    @Override
    public final void resolveAddEdge() {
    }

    @Override
    public final void resolveAddBadge() {
        if (this.removeAdd && this.badge != null) {
            FlowScene scene = this.getScene();
            scene.registerUI(this.badge, (FlowPresenter.FlowUIResolver)this);
            scene.addBadge(this.oldNode, this.badge);
        }
    }

    @Override
    public final void resolveUpdate() {
        FlowScene scene = this.getScene();
        if (this.node != null) {
            scene.updateBadges(this.node);
        }
        if (this.oldNode != null) {
            scene.updateBadges(this.oldNode);
        }
        this.oldNode = null;
    }

    @Override
    public final Collection<? extends FlowDescriptor> getFlowDescriptors() {
        return Collections.emptySet();
    }

    protected abstract FlowNodeDescriptor getNodeDescriptor();

    protected abstract FlowPinDescriptor getPinDescriptor();

    protected abstract FlowBadgeDescriptor getPinBadgeDescriptor();

    @Override
    public abstract FlowBadgeDescriptor.BadgeDecorator getDecorator();

    @Override
    public abstract FlowBadgeDescriptor.BadgeBehaviour getBehaviour();
}

