/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ResourceHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        FileObject fo = env.getFileObject();
        if (fo == null) {
            return;
        }
        FileObject parent = fo.getParent();
        if (!this.openFile(parent.getFileObject(env.getValueString()))) {
            String message = NbBundle.getMessage(ResourceHyperlinkProcessor.class, (String)"LBL_ResourceNotFound", (Object)env.getValueString());
            StatusDisplayer.getDefault().setStatusText(message);
        }
    }

    private boolean openFile(FileObject file) {
        DataObject dObj;
        if (file == null) {
            return false;
        }
        try {
            dObj = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)dObj.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        editorCookie.open();
        return true;
    }
}

