/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class WatchesNodeModelFilter
extends VariablesNodeModel
implements ExtendedNodeModelFilter {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";

    public WatchesNodeModelFilter(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public static boolean isEmptyWatch(Object object) {
        return "EmptyWatch".equals(object.getClass().getSimpleName());
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(WatchesNodeModelFilter.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(object)) {
                return "<_html><font color=\"#808080\">&lt;" + NbBundle.getBundle(WatchesNodeModelFilter.class).getString("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
            }
            return ((JPDAWatch)object).getExpression();
        }
        try {
            return nodeModel.getDisplayName(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            return super.getDisplayName(object);
        }
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return this.getShortDescription(object);
    }

    @Override
    protected String getShortDescriptionSynch(Object object) {
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(object)) {
                return NbBundle.getMessage(WatchesNodeModelFilter.class, (String)"TTP_NewWatch");
            }
            JPDAWatch jPDAWatch = (JPDAWatch)object;
            boolean bl = VariablesTreeModelFilter.isEvaluated(object);
            if (!bl) {
                return jPDAWatch.getExpression();
            }
            String string = jPDAWatch.getExceptionDescription();
            if (string != null) {
                return jPDAWatch.getExpression() + " = >" + string + "<";
            }
            String string2 = jPDAWatch.getType();
            if (string2 == null) {
                return jPDAWatch.getExpression() + " = " + jPDAWatch.getValue();
            }
            try {
                return jPDAWatch.getExpression() + " = (" + jPDAWatch.getType() + ") " + jPDAWatch.getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return super.getShortDescriptionSynch(object);
    }

    @Override
    protected void testKnown(Object object) throws UnknownTypeException {
        if (object instanceof JPDAWatch) {
            return;
        }
        super.testKnown(object);
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canRename(object) || WatchesNodeModelFilter.isEmptyWatch(object);
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCopy(object) && !WatchesNodeModelFilter.isEmptyWatch(object);
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCut(object) && !WatchesNodeModelFilter.isEmptyWatch(object);
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCopy(object);
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCut(object);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        return extendedNodeModel.getPasteTypes(object, transferable);
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
        ((JPDAWatch)object).setExpression(string);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WATCH;
        }
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(object)) {
                return null;
            }
            return WATCH;
        }
        try {
            return extendedNodeModel.getIconBaseWithExtension(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            return super.getIconBaseWithExtension(object);
        }
    }
}

