/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAArrayType;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.debugger.jpda.heapwalk.FieldValueImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.InstanceImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.ObjectFieldValueImpl;
import org.openide.ErrorManager;

public class JavaClassImpl
implements JavaClass {
    private JPDAClassType classType;
    private long instanceCount = -1L;
    private HeapImpl heap;
    private String className;

    public JavaClassImpl(HeapImpl heapImpl, JPDAClassType jPDAClassType) {
        if (jPDAClassType == null) {
            throw new NullPointerException("classType == null");
        }
        this.classType = jPDAClassType;
        this.heap = heapImpl;
    }

    public JavaClassImpl(String string) {
        this.className = string;
    }

    public JavaClassImpl(HeapImpl heapImpl, JPDAClassType jPDAClassType, long l) {
        this.classType = jPDAClassType;
        this.instanceCount = l;
        this.heap = heapImpl;
    }

    public long getJavaClassId() {
        if (this.classType != null) {
            return this.classType.hashCode();
        }
        return this.className.hashCode();
    }

    public Instance getClassLoader() {
        if (this.classType != null) {
            return InstanceImpl.createInstance(this.heap, this.classType.getClassLoader());
        }
        return null;
    }

    public JavaClass getSuperClass() {
        Super super_;
        if (this.classType != null && (super_ = this.classType.getSuperClass()) != null) {
            return new JavaClassImpl(this.heap, super_.getClassType());
        }
        return null;
    }

    public int getInstanceSize() {
        return -1;
    }

    public long getAllInstancesSize() {
        return -1L;
    }

    public List<org.netbeans.lib.profiler.heap.Field> getFields() {
        return Collections.emptyList();
    }

    public List<FieldValue> getStaticFieldValues() {
        if (this.classType == null) {
            return Collections.EMPTY_LIST;
        }
        List list = this.classType.staticFields();
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>(list.size());
        for (Field field : list) {
            if (!field.isStatic()) continue;
            if (field instanceof ObjectVariable) {
                Instance instance = ((ObjectVariable)field).getUniqueID() == 0L ? null : InstanceImpl.createInstance(this.heap, (ObjectVariable)field);
                arrayList.add(new ObjectFieldValueImpl(this.heap, null, field, instance));
                continue;
            }
            arrayList.add(new FieldValueImpl(this.heap, null, field));
        }
        return arrayList;
    }

    public Object getValueOfStaticField(String string) {
        return Collections.EMPTY_LIST;
    }

    public List<Instance> getInstances() {
        if (this.classType == null) {
            return Collections.EMPTY_LIST;
        }
        List list = this.classType.getInstances(0L);
        ArrayList<Instance> arrayList = new ArrayList<Instance>(list.size());
        for (ObjectVariable objectVariable : list) {
            Instance instance = InstanceImpl.createInstance(this.heap, objectVariable);
            arrayList.add(instance);
        }
        return arrayList;
    }

    public int getInstancesCount() {
        if (this.instanceCount != -1L) {
            return (int)this.instanceCount;
        }
        if (this.classType == null) {
            return 0;
        }
        return (int)this.classType.getInstanceCount();
    }

    public String getName() {
        if (this.classType != null) {
            return this.classType.getName();
        }
        return this.className;
    }

    public boolean isArray() {
        return this.classType instanceof JPDAArrayType;
    }

    public List<JavaClass> getSubClasses() {
        if (this.classType != null) {
            try {
                Method method = this.classType.getClass().getMethod("getSubClasses", new Class[0]);
                List list = (List)method.invoke((Object)this.classType, new Object[0]);
                if (list.size() > 0) {
                    long[] lArray = this.heap.getDebugger().getInstanceCounts(list);
                    ArrayList<JavaClassImpl> arrayList = new ArrayList<JavaClassImpl>(list.size());
                    int n = 0;
                    for (JPDAClassType jPDAClassType : list) {
                        arrayList.add(new JavaClassImpl(this.heap, jPDAClassType, lArray[n++]));
                    }
                    return Collections.unmodifiableList(arrayList);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaClassImpl)) {
            return false;
        }
        JavaClassImpl javaClassImpl = (JavaClassImpl)object;
        if (this.classType != null && this.classType.equals(javaClassImpl.classType)) {
            return true;
        }
        return this.className != null && this.className.equals(javaClassImpl.className);
    }

    public int hashCode() {
        if (this.classType != null) {
            return this.classType.hashCode();
        }
        return this.className.hashCode() + 1024;
    }
}

