/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.date;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorDate
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final DateFormat FORMAT_DATE_TIME = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat FORMAT_DATE = new SimpleDateFormat("dd.MM.yyyy");
    private static final DateFormat FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final String NON_DATE_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE_TIME");
    private static final String NON_DATE_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE");
    private static final String NON_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_TIME");
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private DatabindingElement databindingElement;
    private boolean databinding;

    private PropertyEditorDate(boolean databinding) {
        super(NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_UCLABEL"));
        this.databinding = databinding;
    }

    public static final DesignPropertyEditor createInstance() {
        return new PropertyEditorDate(false);
    }

    public static final DesignPropertyEditor createInstanceWithDatabinding() {
        return new PropertyEditorDate(true);
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            if (this.databinding) {
                ArrayList<PropertyEditorElement> elements = new ArrayList<PropertyEditorElement>(2);
                this.databindingElement = new DatabindingElement(this);
                elements.add(this);
                elements.add(this.databindingElement);
                this.initElements(elements);
            } else {
                this.initElements(Collections.singleton(this));
            }
        }
        return super.getCustomEditor();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        if (this.databindingElement != null) {
            this.databindingElement.clean(component);
            this.databindingElement = null;
        }
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSN_Date"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSD_Date"));
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PropertyEditorDate.this.radioButton.isSelected()) {
                    PropertyEditorDate.this.customEditor.textField.requestFocus();
                }
            }
        });
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return false;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String databinding = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (databinding != null) {
            return databinding;
        }
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        return this.getValueAsText((PropertyValue)super.getValue());
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public Boolean canEditAsText() {
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            return false;
        }
        return super.canEditAsText();
    }

    @Override
    public void updateState(PropertyValue value) {
        DesignComponent c = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(c);
        }
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setText(null);
        } else if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(c);
        } else {
            this.customEditor.setText(this.getValueAsText(value));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        int inputMode = this.getInputMode();
        try {
            Date date = this.getFormatter(inputMode).parse(text);
            super.setValue((Object)MidpTypes.createLongValue(date.getTime()));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
        DesignComponent _component = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(_component);
            return;
        }
        if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(_component);
        }
        super.customEditorOKButtonPressed();
    }

    public boolean executeInsideWriteTransaction() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return false;
        }
        return super.executeInsideWriteTransaction();
    }

    @Override
    public boolean isExecuteInsideWriteTransactionUsed() {
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            return true;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    private String getValueAsText(PropertyValue value) {
        Date date = new Date();
        Object valueValue = value.getPrimitiveValue();
        date.setTime((Long)valueValue);
        int inputMode = this.getInputMode();
        return this.getFormatter(inputMode).format(date);
    }

    private DateFormat getFormatter(int inputMode) {
        if (inputMode == 1) {
            return FORMAT_DATE;
        }
        if (inputMode == 2) {
            return FORMAT_TIME;
        }
        return FORMAT_DATE_TIME;
    }

    private int getInputMode() {
        final int[] inputMode = new int[]{3};
        if (this.component != null && this.component.get() != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue pv = _component.readProperty("inputMode");
                    if (pv.getKind() == PropertyValue.Kind.VALUE) {
                        inputMode[0] = MidpTypes.getInteger(pv);
                    }
                }
            });
        }
        return inputMode[0];
    }

    private class CustomEditor
    extends JPanel
    implements DocumentListener,
    FocusListener {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField();
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSN_DateField"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSD_DateField"));
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "Center");
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void checkDateStatus() {
            int inputMode = PropertyEditorDate.this.getInputMode();
            try {
                this.parseDate(inputMode, this.textField.getText());
                PropertyEditorDate.this.clearErrorStatus();
            }
            catch (ParseException e) {
                PropertyEditorDate.this.displayWarning(this.getMessage(inputMode));
            }
        }

        private Date parseDate(int inputMode, String dateAsString) throws ParseException {
            Date result = null;
            DateFormat format = PropertyEditorDate.this.getFormatter(inputMode);
            format.setLenient(false);
            ParsePosition pp = new ParsePosition(0);
            result = format.parse(dateAsString, pp);
            if (result == null || pp.getIndex() != dateAsString.length()) {
                throw new ParseException(null, pp.getIndex());
            }
            return result;
        }

        private String getMessage(int inputMode) {
            if (inputMode == 1) {
                return NON_DATE_TEXT;
            }
            if (inputMode == 2) {
                return NON_TIME_TEXT;
            }
            return NON_DATE_TIME_TEXT;
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            boolean isSelected = PropertyEditorDate.this.radioButton.isSelected();
            if (!isSelected) {
                PropertyEditorDate.this.radioButton.setSelected(true);
            }
            this.checkDateStatus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorDate.this.clearErrorStatus();
        }
    }
}

