/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.java.navigation.HTMLDocView;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class ToolTipManagerEx
extends MouseAdapter
implements MouseMotionListener {
    private static final Logger LOG = Logger.getLogger(ToolTipManagerEx.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ToolTipManagerEx.class.getName(), 1, false, false);
    private Timer enterTimer;
    private Timer exitTimer;
    private String toolTipText;
    private JComponent insideComponent;
    private MouseEvent mouseEvent;
    private boolean showImmediately;
    private transient Popup tipWindow;
    private Window window;
    private ToolTipEx tip;
    private Rectangle popupRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private MouseMotionListener moveBeforeEnterListener = null;
    private ToolTipProvider provider;
    private static final String WAITING_TEXT = NbBundle.getMessage(ToolTipManagerEx.class, (String)"LBL_PleaseWait");
    private AWTEventListener awtListener;
    private Rectangle lastTooltipForRect;
    private String lastTooltipText;
    private RequestProcessor.Task tooltipTask;
    private static final Object TOOLTIP_DATA_LOCK = new Object();

    public ToolTipManagerEx(ToolTipProvider provider) {
        assert (null != provider);
        this.provider = provider;
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
        this.registerComponent(provider.getComponent());
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!flag) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitialDelay(int milliseconds) {
        this.enterTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setReshowDelay(int milliseconds) {
        this.exitTimer.setInitialDelay(milliseconds);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    protected void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        for (Container p = this.insideComponent.getParent(); p != null && !(p instanceof JPopupMenu); p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            if (((Window)p).isFocused()) break;
            return;
        }
        if (this.enabled) {
            this.hideTipWindow();
            this.tip = this.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension size = this.tip.getPreferredSize();
            Point location = this.provider.getToolTipLocation(this.mouseEvent.getPoint(), size);
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(location.x, location.y, size.width, size.height);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, location.x, location.y);
            this.tipWindow.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != componentWindow) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTListener(), 8L);
            this.tipShowing = true;
        }
    }

    protected void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            if (null != this.awtListener) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTListener());
            }
        }
    }

    protected void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap == null || actionMap != null) {
                // empty if block
            }
        }
    }

    protected void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap == null || actionMap != null) {
                // empty if block
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent component) {
        InputMap inputMap;
        for (inputMap = component.getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
        }
        return inputMap != null;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    private void initiateToolTip(MouseEvent event) {
        if (event.getSource() == this.window) {
            return;
        }
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        boolean sameComponent = this.insideComponent == component;
        this.insideComponent = component;
        if (this.tipWindow != null) {
            this.mouseEvent = event;
            if (this.showImmediately) {
                Rectangle rect = this.provider.getToolTipSourceBounds(event.getPoint());
                if (null != rect) {
                    String newToolTipText = this.startToolTipCalculation(rect, event.getPoint());
                    if (!sameComponent || !this.toolTipText.equals(newToolTipText)) {
                        this.toolTipText = newToolTipText;
                        this.showTipWindow();
                    }
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        boolean shouldHide = true;
        if (this.insideComponent != null) {
            Window win;
            if (this.window != null && event.getSource() == this.window) {
                Container insideComponentWindow = this.insideComponent.getTopLevelAncestor();
                if (insideComponentWindow != null) {
                    Point location = event.getPoint();
                    SwingUtilities.convertPointToScreen(location, this.window);
                    location.x -= insideComponentWindow.getX();
                    location.y -= insideComponentWindow.getY();
                    location = SwingUtilities.convertPoint(null, location, this.insideComponent);
                    shouldHide = location.x < 0 || location.x >= this.insideComponent.getWidth() || location.y < 0 || location.y >= this.insideComponent.getHeight();
                }
            } else if (event.getSource() == this.insideComponent && this.tipWindow != null && (win = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
                Point location = SwingUtilities.convertPoint(this.insideComponent, event.getPoint(), win);
                Rectangle bounds = this.insideComponent.getTopLevelAncestor().getBounds();
                location.x += bounds.x;
                location.y += bounds.y;
                Point loc = new Point(0, 0);
                SwingUtilities.convertPointToScreen(loc, this.tip);
                bounds.x = loc.x;
                bounds.y = loc.y;
                bounds.width = this.tip.getWidth();
                bounds.height = this.tip.getHeight();
                shouldHide = true;
            }
        }
        if (shouldHide) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else if (this.showImmediately) {
            Rectangle rect = this.provider.getToolTipSourceBounds(event.getPoint());
            if (null != rect) {
                JComponent component = (JComponent)event.getSource();
                this.toolTipText = this.startToolTipCalculation(rect, event.getPoint());
                if (this.toolTipText != null) {
                    this.mouseEvent = event;
                    this.insideComponent = component;
                    this.exitTimer.stop();
                    this.showTipWindow();
                }
            }
        } else {
            this.insideComponent = (JComponent)event.getSource();
            this.mouseEvent = event;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        Rectangle newRect = this.provider.getToolTipSourceBounds(event.getPoint());
        if (newRect != null) {
            this.mouseEvent = event;
            if (newRect.equals(this.lastTooltipForRect)) {
                if (this.tipWindow == null) {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = this.startToolTipCalculation(newRect, event.getPoint());
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    protected ToolTipEx createToolTip() {
        return new ToolTipEx();
    }

    protected AWTEventListener getAWTListener() {
        if (null == this.awtListener) {
            this.awtListener = new AWTEventListener(){
                boolean armed = false;

                @Override
                public void eventDispatched(AWTEvent e) {
                    if (e instanceof KeyEvent) {
                        KeyEvent ke = (KeyEvent)e;
                        if (ke.getKeyCode() == 112 && (ke.isControlDown() || ke.isMetaDown())) {
                            if (ke.getID() == 401) {
                                this.armed = true;
                                return;
                            }
                            if (ke.getID() == 402 && this.armed) {
                                ke.consume();
                                this.armed = false;
                                ToolTipManagerEx.this.provider.invokeUserAction(ToolTipManagerEx.this.mouseEvent);
                                ToolTipManagerEx.this.hideTipWindow();
                                return;
                            }
                        } else if (ke.getKeyCode() != 17 && ke.getKeyCode() != 157) {
                            this.armed = false;
                        }
                    }
                }
            };
        }
        return this.awtListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startToolTipCalculation(Rectangle tooltipForRect, Point loc) {
        Object object = TOOLTIP_DATA_LOCK;
        synchronized (object) {
            if (tooltipForRect.equals(this.lastTooltipForRect)) {
                return this.lastTooltipText;
            }
            if (this.tooltipTask != null) {
                boolean cancelled = this.tooltipTask.cancel();
                this.tooltipTask = null;
            }
            this.lastTooltipForRect = new Rectangle(tooltipForRect);
        }
        TooltipCalculator tc = new TooltipCalculator(tooltipForRect, loc);
        Object object2 = TOOLTIP_DATA_LOCK;
        synchronized (object2) {
            this.tooltipTask = RP.post((Runnable)tc);
        }
        return WAITING_TEXT;
    }

    private Dimension getDefaultToolTipSize() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        String size = prefs.get("javadoc-preferred-size", null);
        Dimension dim = size == null ? null : ToolTipManagerEx.parseDimension(size);
        return dim != null ? dim : new Dimension(500, 300);
    }

    private static Dimension parseDimension(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] arr = new int[2];
        int i = 0;
        while (st.hasMoreElements()) {
            if (i > 1) {
                return null;
            }
            try {
                arr[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                LOG.log(Level.WARNING, null, nfe);
                return null;
            }
            ++i;
        }
        if (i != 2) {
            return null;
        }
        return new Dimension(arr[0], arr[1]);
    }

    private class ToolTipEx
    extends JPanel {
        private HTMLDocView content;
        private JLabel shortcut;

        public ToolTipEx() {
            super(new GridBagLayout());
            this.setPreferredSize(ToolTipManagerEx.this.getDefaultToolTipSize());
            Color background = new JEditorPane().getBackground();
            background = new Color(Math.max(background.getRed() - 8, 0), Math.max(background.getGreen() - 8, 0), background.getBlue());
            this.setBackground(background);
            this.content = new HTMLDocView(background);
            JScrollPane scroll = new JScrollPane(this.content);
            scroll.setHorizontalScrollBarPolicy(31);
            this.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.shortcut = new JLabel(NbBundle.getMessage(ToolTipManagerEx.class, (String)"HINT_EnlargeJavaDocToolip", (Object)(Utilities.isMac() ? KeyEvent.getKeyText(157) + "+F1" : "Ctrl+F1")));
            this.shortcut.setHorizontalAlignment(0);
            this.shortcut.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.shortcut, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setTipText(String text) {
            if (WAITING_TEXT.equals(text)) {
                this.content.setContent(WAITING_TEXT, null);
                this.shortcut.setVisible(false);
            } else {
                this.content.setContent(text, null);
                this.shortcut.setVisible(true);
            }
        }
    }

    private class TooltipCalculator
    implements Runnable {
        private Point location;
        private Rectangle tooltipForRect;

        TooltipCalculator(Rectangle tooltipForRect, Point loc) {
            this.tooltipForRect = tooltipForRect;
            this.location = loc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final String result = ToolTipManagerEx.this.provider.getToolTipText(this.location);
            if (null == result) {
                return;
            }
            Object object = TOOLTIP_DATA_LOCK;
            synchronized (object) {
                ToolTipManagerEx.this.tooltipTask = null;
                if (ToolTipManagerEx.this.lastTooltipForRect == null || !this.tooltipForRect.equals(ToolTipManagerEx.this.lastTooltipForRect)) {
                    return;
                }
                ToolTipManagerEx.this.lastTooltipText = result;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolTipManagerEx.this.toolTipText = result;
                    if (null != ToolTipManagerEx.this.tip) {
                        ToolTipManagerEx.this.tip.setTipText(ToolTipManagerEx.this.toolTipText);
                        ToolTipManagerEx.this.tip.invalidate();
                        ToolTipManagerEx.this.tip.revalidate();
                        ToolTipManagerEx.this.tip.repaint();
                    }
                }
            });
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ToolTipManagerEx.this.initiateToolTip(e);
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTipManagerEx.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolTipManagerEx.this.insideComponent != null && ToolTipManagerEx.this.insideComponent.isShowing()) {
                Rectangle rect;
                if (ToolTipManagerEx.this.toolTipText == null && ToolTipManagerEx.this.mouseEvent != null && null != (rect = ToolTipManagerEx.this.provider.getToolTipSourceBounds(ToolTipManagerEx.this.mouseEvent.getPoint()))) {
                    ToolTipManagerEx.this.toolTipText = ToolTipManagerEx.this.startToolTipCalculation(rect, ToolTipManagerEx.this.mouseEvent.getPoint());
                }
                if (ToolTipManagerEx.this.toolTipText != null) {
                    ToolTipManagerEx.this.showImmediately = true;
                    ToolTipManagerEx.this.showTipWindow();
                } else {
                    ToolTipManagerEx.this.insideComponent = null;
                    ToolTipManagerEx.this.toolTipText = null;
                    ToolTipManagerEx.this.mouseEvent = null;
                    ToolTipManagerEx.this.hideTipWindow();
                }
            }
        }
    }

    static interface ToolTipProvider {
        public JComponent getComponent();

        public String getToolTipText(Point var1);

        public Rectangle getToolTipSourceBounds(Point var1);

        public Point getToolTipLocation(Point var1, Dimension var2);

        public void invokeUserAction(MouseEvent var1);
    }
}

