/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.signature;

import com.sun.jersey.oauth.signature.Methods;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import com.sun.jersey.oauth.signature.OAuthSignatureMethod;
import com.sun.jersey.oauth.signature.URLCodec;
import com.sun.jersey.oauth.signature.UnsupportedSignatureMethodException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OAuthSignature {
    public static String generate(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        return OAuthSignature.getSignatureMethod(params).sign(OAuthSignature.elements(request, params), secrets);
    }

    public static void sign(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        params = (OAuthParameters)params.clone();
        params.setSignature(OAuthSignature.generate(request, params, secrets));
        params.writeRequest(request);
    }

    public static boolean verify(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        return OAuthSignature.getSignatureMethod(params).verify(OAuthSignature.elements(request, params), secrets, params.getSignature());
    }

    private static String normalizeParameters(OAuthRequest request, OAuthParameters params) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : params.keySet()) {
            String value;
            if (key.equals("realm") || key.equals("oauth_signature") || (value = (String)params.get(key)) == null) continue;
            list.add(URLCodec.encode(key) + '=' + URLCodec.encode(value));
        }
        for (String key : request.getParameterNames()) {
            List<String> values;
            if (key.startsWith("oauth_") && params.containsKey(key) || (values = request.getParameterValues(key)) == null) continue;
            for (String value : values) {
                list.add(URLCodec.encode(key) + '=' + URLCodec.encode(value));
            }
        }
        Collections.sort(list);
        StringBuffer buf = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            buf.append((String)i.next());
            if (!i.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    private static String constructRequestURL(OAuthRequest request) throws OAuthSignatureException {
        URL url;
        try {
            url = new URL(request.getRequestURL());
        }
        catch (MalformedURLException mue) {
            throw new OAuthSignatureException(mue);
        }
        StringBuffer buf = new StringBuffer(url.getProtocol()).append("://").append(url.getHost().toLowerCase());
        int port = url.getPort();
        if (port > 0 && port != url.getDefaultPort()) {
            buf.append(':').append(port);
        }
        buf.append(url.getPath());
        return buf.toString();
    }

    private static String elements(OAuthRequest request, OAuthParameters params) throws OAuthSignatureException {
        StringBuffer buf = new StringBuffer(URLCodec.encode(request.getRequestMethod().toUpperCase()));
        buf.append('&').append(URLCodec.encode(OAuthSignature.constructRequestURL(request)));
        buf.append('&').append(URLCodec.encode(OAuthSignature.normalizeParameters(request, params)));
        return buf.toString();
    }

    private static OAuthSignatureMethod getSignatureMethod(OAuthParameters params) throws UnsupportedSignatureMethodException {
        OAuthSignatureMethod method = Methods.getInstance(params.getSignatureMethod());
        if (method == null) {
            throw new UnsupportedSignatureMethodException(params.getSignatureMethod());
        }
        return method;
    }
}

