/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("j2seproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private final Project project;
    private final RakeProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private final String projectConfigurationNamespace;

    UpdateHelper(Project project, RakeProjectHelper helper, AuxiliaryConfiguration cfg, GeneratedFilesHelper genFileHelper, Notifier notifier, String projectConfigurationNamespace) {
        assert (project != null && helper != null && cfg != null && genFileHelper != null && notifier != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
        this.genFileHelper = genFileHelper;
        this.notifier = notifier;
        this.projectConfigurationNamespace = projectConfigurationNamespace;
    }

    public EditableProperties getProperties(final String path) {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return UpdateHelper.this.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public RakeProjectHelper getRakeProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate();
        return true;
    }

    public synchronized boolean isCurrent() {
        return true;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.notifier.canUpdate();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate() throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateHelper updateHelper = this;
        synchronized (updateHelper) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            // empty if block
        }
        return this.cachedElement;
    }

    private synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties cachedProperties = this.helper.getProperties("nbproject/project.properties");
        return cachedProperties;
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            @Override
            public boolean canUpdate() {
                JButton updateOption = new JButton(NbBundle.getMessage(UpdateHelper.class, (String)"CTL_UpdateOption"));
                updateOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateHelper.class, (String)"AD_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
            }
        };
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

