/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.openide.util.Parameters;

public final class ContextKnowledge {
    private Map<String, RubyType> typesForSymbols;
    private Map<Node, RubyType> typesForNodes;
    private final RubyIndex index;
    private final Node root;
    private final Node target;
    private final int astOffset;
    private final int lexOffset;
    private final ParserResult parserResult;
    private List<AstMethodElement> analyzedMethods;
    private boolean analyzed;

    ContextKnowledge(RubyIndex index, Node root, ParserResult parserResult) {
        this(index, root, null, -1, -1, parserResult);
    }

    public ContextKnowledge(RubyIndex index, Node root, Node target, int astOffset, int lexOffset, ParserResult parserResult) {
        Parameters.notNull((CharSequence)"root", (Object)root);
        Parameters.notNull((CharSequence)"parserResult", (Object)parserResult);
        this.index = index;
        this.root = root;
        this.target = target;
        this.astOffset = astOffset;
        this.lexOffset = lexOffset;
        this.typesForSymbols = new HashMap<String, RubyType>();
        this.typesForNodes = new HashMap<Node, RubyType>();
        this.parserResult = parserResult;
    }

    void setAnalyzedMethods(List<AstMethodElement> analyzedMethods) {
        this.analyzedMethods = analyzedMethods;
    }

    RubyType getTypeForMethod(String clazz, String methodName) {
        if (this.analyzedMethods == null || this.analyzedMethods.isEmpty()) {
            return null;
        }
        for (AstMethodElement each : this.analyzedMethods) {
            String in = each.getIn();
            if (in == null || !in.equals(clazz) || !each.getName().equals(methodName)) continue;
            return each.getType();
        }
        return null;
    }

    RubyType getType(String symbol) {
        RubyType type = this.typesForSymbols.get(symbol);
        return type == null ? RubyType.unknown() : type;
    }

    RubyType getType(Node node) {
        return this.typesForNodes.get(node);
    }

    void setType(Node node, RubyType type) {
        this.typesForNodes.put(node, type);
    }

    void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    boolean wasAnalyzed() {
        return this.analyzed;
    }

    Map<String, RubyType> getTypesForSymbols() {
        return this.typesForSymbols;
    }

    void maybePutTypeForSymbol(String var, String type, boolean override) {
        this.maybePutTypeForSymbol(var, RubyType.create(type), override);
    }

    void maybePutTypeForSymbol(String symbol, RubyType newType, boolean override) {
        RubyType mapType = this.typesForSymbols.get(symbol);
        if (mapType == null || override) {
            mapType = new RubyType();
            this.typesForSymbols.put(symbol, mapType);
        }
        mapType.append(newType);
    }

    static RubyType getTypesForSymbol(Map<String, RubyType> typeForSymbol, String name) {
        RubyType type = typeForSymbol.get(name);
        return type == null ? RubyType.unknown() : type;
    }

    int getAstOffset() {
        return this.astOffset;
    }

    RubyIndex getIndex() {
        return this.index;
    }

    int getLexOffset() {
        return this.lexOffset;
    }

    Node getRoot() {
        return this.root;
    }

    ParserResult getParserResult() {
        return this.parserResult;
    }

    Node getTarget() {
        return this.target;
    }

    public String toString() {
        return "ContextKnowledge[realTypes:" + this.typesForSymbols + ']';
    }
}

