/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class ExpressionPool {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private Map<ExpressionLocation, Expression> expressions = new HashMap<ExpressionLocation, Expression>();

    ExpressionPool() {
    }

    public synchronized Expression getExpressionAt(Location location, String string) {
        try {
            ExpressionLocation expressionLocation = new ExpressionLocation(LocationWrapper.method(location), LocationWrapper.lineNumber(location));
            if (!this.expressions.containsKey(expressionLocation)) {
                Expression expression = this.createExpressionAt(location, string);
                this.expressions.put(expressionLocation, expression);
            }
            return this.expressions.get(expressionLocation);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUnusedExpressions(ThreadReference threadReference) {
        Object object = this;
        synchronized (object) {
            if (this.expressions.size() == 0) {
                return;
            }
        }
        try {
            object = ThreadReferenceWrapper.frames(threadReference);
            ExpressionPool expressionPool = this;
            synchronized (expressionPool) {
                Iterator<ExpressionLocation> iterator = this.expressions.keySet().iterator();
                while (iterator.hasNext()) {
                    ExpressionLocation expressionLocation = iterator.next();
                    Method method = expressionLocation.getMethod();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        StackFrame stackFrame = (StackFrame)iterator2.next();
                        if (!((Object)method).equals(LocationWrapper.method(StackFrameWrapper.location(stackFrame)))) continue;
                        method = null;
                        break;
                    }
                    if (method == null) continue;
                    iterator.remove();
                }
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            // empty catch block
        }
    }

    private Expression createExpressionAt(Location location, String string) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List<Location> list;
        VirtualMachine virtualMachine = MirrorWrapper.virtualMachine(location);
        if (!VirtualMachineWrapper.canGetBytecodes(virtualMachine)) {
            return null;
        }
        ReferenceType referenceType = LocationWrapper.declaringType(location);
        Method method = LocationWrapper.method(location);
        final byte[] byArray = MethodWrapper.bytecodes(method);
        byte[] byArray2 = null;
        if (VirtualMachineWrapper.canGetConstantPool(virtualMachine)) {
            byArray2 = ReferenceTypeWrapper.constantPool(referenceType);
        }
        final byte[] byArray3 = byArray2;
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        final String string2 = session == null ? null : session.getCurrentLanguage();
        int n = LocationWrapper.lineNumber(location, string2);
        try {
            list = MethodWrapper.allLineLocations(method, string2, null);
        }
        catch (AbsentInformationException absentInformationException) {
            logger.log(Level.FINE, absentInformationException.getLocalizedMessage());
            return null;
        }
        EditorContext.Operation[] operationArray = EditorContextBridge.getContext().getOperations(string, n, new EditorContext.BytecodeProvider(){

            public byte[] constantPool() {
                return byArray3;
            }

            public byte[] byteCodes() {
                return byArray;
            }

            public int[] indexAtLines(int n, int n2) {
                return ExpressionPool.getIndexesAtLines(list, string2, n, n2, byArray.length);
            }
        });
        if (operationArray == null) {
            logger.log(Level.FINE, "Unsuccessfull bytecode matching.");
            return null;
        }
        if (operationArray.length == 0) {
            return null;
        }
        Location[] locationArray = new Location[operationArray.length];
        for (int i = 0; i < operationArray.length; ++i) {
            int n2 = operationArray[i].getBytecodeIndex();
            locationArray[i] = MethodWrapper.locationOfCodeIndex(method, n2);
            if (locationArray[i] != null) continue;
            logger.log(Level.FINE, "Location of the operation not found.");
            return null;
        }
        Expression expression = new Expression(new ExpressionLocation(method, n), operationArray, locationArray);
        return expression;
    }

    private static int[] getIndexesAtLines(List<Location> list, String string, int n, int n2, int n3) {
        int n4 = 0;
        try {
            Location location;
            int n5 = LocationWrapper.lineNumber(list.get(0), string);
            while ((location = ExpressionPool.getLocationOfLine(list, string, n - n4++)) == null && n - (n4 - 1) >= n5) {
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        int n6 = n2 > n - (n4 - 1) ? 0 : 1;
        n -= n4 - 1;
        n2 += n6;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n7 = -1;
        try {
            for (Location location : list) {
                int n8 = LocationWrapper.lineNumber(location, string);
                if (n7 == -1 && n <= n8 && n8 < n2) {
                    n7 = (int)LocationWrapper.codeIndex(location);
                    continue;
                }
                if (n7 < 0) continue;
                arrayList.add(new int[]{n7, (int)LocationWrapper.codeIndex(location)});
                n7 = -1;
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        if (arrayList.size() == 0) {
            if (n7 >= 0) {
                return new int[]{n7, n3};
            }
            return null;
        }
        if (arrayList.size() == 1) {
            return (int[])arrayList.get(0);
        }
        Object object = new int[2 * arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[2 * i] = ((int[])arrayList.get(i))[0];
            object[2 * i + 1] = ((int[])arrayList.get(i))[1];
        }
        return object;
    }

    private static Location getLocationOfLine(List<Location> list, String string, int n) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        for (Location location : list) {
            if (LocationWrapper.lineNumber(location, string) != n) continue;
            return location;
        }
        return null;
    }

    public static final class OperationLocation {
        private EditorContext.Operation op;
        private Location loc;
        private int index;

        OperationLocation(EditorContext.Operation operation, Location location, int n) {
            this.op = operation;
            this.loc = location;
            this.index = n;
        }

        public EditorContext.Operation getOperation() {
            return this.op;
        }

        public Location getLocation() {
            return this.loc;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class ExpressionLocation {
        private Method method;
        private int line;

        public ExpressionLocation(Method method, int n) {
            this.method = method;
            this.line = n;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExpressionLocation)) {
                return false;
            }
            return ((ExpressionLocation)object).line == this.line && ((Object)((ExpressionLocation)object).method).equals(this.method);
        }

        public int hashCode() {
            return ((Object)this.method).hashCode() + this.line;
        }
    }

    public static final class Expression {
        private ExpressionLocation location;
        private EditorContext.Operation[] operations;
        private Location[] locations;

        Expression(ExpressionLocation expressionLocation, EditorContext.Operation[] operationArray, Location[] locationArray) {
            this.location = expressionLocation;
            this.operations = operationArray;
            this.locations = locationArray;
        }

        public EditorContext.Operation[] getOperations() {
            return this.operations;
        }

        public Location[] getLocations() {
            return this.locations;
        }

        public int findNextOperationIndex(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 <= n) continue;
                return i;
            }
            return -1;
        }

        int[] findNextOperationIndexes(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                List list;
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 == n && !(list = this.operations[i].getNextOperations()).isEmpty()) {
                    int n3 = list.size();
                    int[] nArray = new int[n3];
                    for (int j = 0; j < n3; ++j) {
                        int n4;
                        EditorContext.Operation operation = (EditorContext.Operation)list.get(j);
                        for (n4 = 0; n4 < this.operations.length && operation != this.operations[n4]; ++n4) {
                        }
                        nArray[j] = n4 < this.operations.length ? n4 : -1;
                    }
                    return nArray;
                }
                if (n2 <= n) continue;
                return new int[]{i};
            }
            return null;
        }

        OperationLocation[] findNextOperationLocations(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                List list;
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 == n && !(list = this.operations[i].getNextOperations()).isEmpty()) {
                    int n3 = list.size();
                    OperationLocation[] operationLocationArray = new OperationLocation[n3];
                    for (int j = 0; j < n3; ++j) {
                        Location location;
                        int n4;
                        EditorContext.Operation operation = (EditorContext.Operation)list.get(j);
                        for (n4 = 0; n4 < this.operations.length && operation != this.operations[n4]; ++n4) {
                        }
                        if (n4 < this.operations.length) {
                            operationLocationArray[j] = new OperationLocation(this.operations[n4], this.locations[n4], n4);
                            continue;
                        }
                        int n5 = operation.getBytecodeIndex();
                        try {
                            location = MethodWrapper.locationOfCodeIndex(this.location.getMethod(), n5);
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                            return null;
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return null;
                        }
                        if (location == null) {
                            logger.log(Level.FINE, "Location of the operation not found.");
                            return null;
                        }
                        operationLocationArray[j] = new OperationLocation(operation, location, -1);
                    }
                    return operationLocationArray;
                }
                if (n2 <= n) continue;
                return new OperationLocation[]{new OperationLocation(this.operations[i], this.locations[i], i)};
            }
            return null;
        }
    }
}

