/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.options;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.options.CvsOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

class CvsOptionsController
extends OptionsPanelController {
    private CvsOptionsPanel panel;

    CvsOptionsController() {
    }

    public void update() {
        this.panel.getExcludeNewFiles().setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false));
        this.panel.getStatusLabelFormat().setText(CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]"));
        int wrapLength = CvsModuleConfig.getDefault().getWrapCommitMessagelength();
        this.panel.getWrapCommitMessages().setSelected(wrapLength > 0);
        this.panel.getWrapCharCount().setText(wrapLength > 0 ? Integer.toString(wrapLength) : "");
        this.panel.getPruneDirectories().setSelected(CvsModuleConfig.getDefault().getAutoPruneDirectories());
    }

    public void applyChanges() {
        if (!this.isValid()) {
            return;
        }
        CvsModuleConfig.getDefault().getPreferences().putBoolean("excludeNewFiles", this.panel.getExcludeNewFiles().isSelected());
        CvsModuleConfig.getDefault().getPreferences().put("annotationsFormat", this.panel.getStatusLabelFormat().getText());
        int wrapLength = this.panel.getWrapCommitMessages().isSelected() ? Integer.parseInt(this.panel.getWrapCharCount().getText().trim()) : 0;
        CvsModuleConfig.getDefault().setWrapCommitMessagelength(wrapLength);
        CvsModuleConfig.getDefault().setAutoPruneDirectories(this.panel.getPruneDirectories().isSelected());
    }

    public void cancel() {
    }

    public boolean isValid() {
        try {
            return !this.panel.getWrapCommitMessages().isSelected() || Integer.parseInt(this.panel.getWrapCharCount().getText().trim()) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isChanged() {
        boolean originalWrapMessages;
        if (this.panel.getExcludeNewFiles().isSelected() != CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false)) {
            return true;
        }
        if (!this.panel.getStatusLabelFormat().getText().equals(CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]"))) {
            return true;
        }
        int originalWrapLength = CvsModuleConfig.getDefault().getWrapCommitMessagelength();
        boolean bl = originalWrapMessages = originalWrapLength > 0;
        if (this.panel.getWrapCommitMessages().isSelected() != originalWrapMessages) {
            return true;
        }
        if (originalWrapMessages && !this.panel.getWrapCharCount().getText().equals(Integer.toString(originalWrapLength))) {
            return true;
        }
        return this.panel.getPruneDirectories().isSelected() != CvsModuleConfig.getDefault().getAutoPruneDirectories();
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.panel == null) {
            this.panel = new CvsOptionsPanel();
        }
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CvsOptionsController.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

