/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class JspWatchesTreeFilter
implements TreeModelFilter {
    private final JPDADebugger debugger;
    private final Map<Watch, JspElWatch> watch2JspElWatch = new HashMap<Watch, JspElWatch>();
    private DebuggerListener listener;

    public JspWatchesTreeFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object == treeModel.getRoot()) {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            Object[] objectArray = treeModel.getChildren(object, n, n2);
            Object[] objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            Map<Watch, JspElWatch> map = this.watch2JspElWatch;
            synchronized (map) {
                for (int i = n; i < watchArray.length; ++i) {
                    Watch watch = watchArray[i];
                    String string = watch.getExpression();
                    if (!this.isJSPexpression(string)) continue;
                    JspElWatch jspElWatch = this.watch2JspElWatch.get(watch);
                    if (jspElWatch == null) {
                        jspElWatch = new JspElWatch(watch, this.debugger);
                        this.watch2JspElWatch.put(watch, jspElWatch);
                    }
                    objectArray2[i - n] = jspElWatch;
                }
            }
            if (this.listener == null) {
                this.listener = new DebuggerListener(this, this.debugger);
            }
            return objectArray2;
        }
        return treeModel.getChildren(object, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object == treeModel.getRoot() && this.listener == null) {
            this.listener = new DebuggerListener(this, this.debugger);
        }
        return treeModel.getChildrenCount(object);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof JspElWatch) {
            return true;
        }
        return treeModel.isLeaf(object);
    }

    private boolean isJSPexpression(String string) {
        return string.startsWith("${") && string.endsWith("}");
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        Map<Watch, JspElWatch> map = this.watch2JspElWatch;
        synchronized (map) {
            for (JspElWatch jspElWatch : this.watch2JspElWatch.values()) {
                jspElWatch.setUnevaluated();
            }
        }
    }

    private static class DebuggerListener
    implements PropertyChangeListener {
        WeakReference<JspWatchesTreeFilter> jspWatchesFilterRef;
        WeakReference<JPDADebugger> debuggerRef;

        DebuggerListener(JspWatchesTreeFilter jspWatchesTreeFilter, JPDADebugger jPDADebugger) {
            this.jspWatchesFilterRef = new WeakReference<JspWatchesTreeFilter>(jspWatchesTreeFilter);
            this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (((JPDADebugger)this.debuggerRef.get()).getState() == 4) {
                this.destroy();
                return;
            }
            if (((JPDADebugger)this.debuggerRef.get()).getState() == 2) {
                return;
            }
            JspWatchesTreeFilter jspWatchesTreeFilter = this.getJspWatchesFilter();
            if (jspWatchesTreeFilter != null) {
                jspWatchesTreeFilter.fireTreeChanged();
            }
        }

        private JspWatchesTreeFilter getJspWatchesFilter() {
            JspWatchesTreeFilter jspWatchesTreeFilter = (JspWatchesTreeFilter)this.jspWatchesFilterRef.get();
            if (jspWatchesTreeFilter == null) {
                this.destroy();
            }
            return jspWatchesTreeFilter;
        }

        private void destroy() {
            JPDADebugger jPDADebugger = (JPDADebugger)this.debuggerRef.get();
            if (jPDADebugger != null) {
                jPDADebugger.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

