/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.options.ContextOptionsListener;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.options.ContextSystemOption;
import org.openide.text.PrintSettings;
import org.openide.util.HelpCtx;

public class BasePrintOptions
extends OptionSupport {
    public static final String BASE = "base";
    public static final String PRINT_PREFIX = "print_";
    public static final String PRINT_COLORING_MAP_PROP = "printColoringMap";
    private static final String HELP_ID = "editing.fontsandcolors";
    static final String[] BASE_PROP_NAMES = new String[]{"printColoringMap"};
    static final long serialVersionUID = 7740651671176408299L;

    public BasePrintOptions() {
        this(BaseKit.class, BASE);
    }

    public BasePrintOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
    }

    @Override
    public String displayName() {
        String name;
        try {
            name = this.getString("OPTIONS_print_" + this.getTypeName());
        }
        catch (Throwable t) {
            name = super.displayName();
        }
        return name;
    }

    public void init() {
        this.refreshContextListeners();
    }

    private void refreshContextListeners() {
        PrintSettings ps = (PrintSettings)PrintSettings.findObject(PrintSettings.class, (boolean)true);
        ContextOptionsListener.processExistingAndListen((ContextSystemOption)ps);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    @Override
    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-print-options-initalizer";
    }

    public boolean getPrintLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setPrintLineNumberVisible(boolean b) {
    }

    public Map getPrintColoringMap() {
        Map<String, Coloring> cm = SettingsUtil.getColoringMap(this.getKitClass(), true, true);
        cm.put(null, (Coloring)this.getKitClass().getName());
        return cm;
    }

    public void setPrintColoringMap(Map coloringMap) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }
}

