/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sync;

import java.awt.Color;
import java.beans.FeatureDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIODCConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionName;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class SyncToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final int INDICATOR_POSITION = 300;
    private static final String ID = "dlight.tool.sync";
    private static final String TOOL_NAME = SyncToolConfigurationProvider.loc("SyncTool.ToolName", new String[0]);
    private static final String TOOL_DESCRIPTION = SyncToolConfigurationProvider.loc("SyncTool.ToolDescription", new String[0]);
    private static final DataTableMetadata.Column timestampColumn = new DataTableMetadata.Column("timestamp", Time.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.timestamp", new String[0]), null);
    private static final DataTableMetadata.Column waiterColumn = new DataTableMetadata.Column("waiter", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.waiter", new String[0]), null);
    private static final DataTableMetadata.Column mutexColumn = new DataTableMetadata.Column("mutex", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.mutex", new String[0]), null);
    private static final DataTableMetadata.Column blockerColumn = new DataTableMetadata.Column("blocker", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.blocker", new String[0]), null);
    private static final DataTableMetadata.Column timeColumn = new DataTableMetadata.Column("time", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.time", new String[0]), null);
    private static final DataTableMetadata.Column stackColumn = new DataTableMetadata.Column("stackid", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.stackid", new String[0]), null);
    private static final DataTableMetadata.Column locksColumn = new DataTableMetadata.Column("locks", Float.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.locks", new String[0]), null);
    private static final DataTableMetadata.Column threadsColumn = new DataTableMetadata.Column("threads", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.threads", new String[0]), null);
    private static final DataTableMetadata rawTableMetadata;

    public DLightToolConfiguration create() {
        DLightToolConfiguration toolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        toolConfiguration.setLongName(TOOL_DESCRIPTION);
        toolConfiguration.setDescription(SyncToolConfigurationProvider.loc("SyncTool.ToolDescription.Details", new String[0]));
        toolConfiguration.setIcon("org/netbeans/modules/dlight/sync/resources/threads.png");
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setValue("dtrace.script", this.getScriptUrl());
        toolConfiguration.setFeatureDescriptor(descriptor);
        List<DataCollectorConfiguration> dcConfigurations = this.initDataCollectorConfigurations();
        for (DataCollectorConfiguration dc : dcConfigurations) {
            toolConfiguration.addDataCollectorConfiguration(dc);
        }
        List<IndicatorDataProviderConfiguration> idpcs = this.initIndicatorDataProviderConfigurations();
        for (IndicatorDataProviderConfiguration idpc : idpcs) {
            toolConfiguration.addIndicatorDataProviderConfiguration(idpc);
        }
        IndicatorConfiguration ic = this.initIndicatorConfiguration();
        toolConfiguration.addIndicatorConfiguration(ic);
        return toolConfiguration;
    }

    private URL getScriptUrl() {
        return this.getClass().getResource("resources/sync.d");
    }

    private List<DataCollectorConfiguration> initDataCollectorConfigurations() {
        ArrayList<DataCollectorConfiguration> result = new ArrayList<DataCollectorConfiguration>();
        result.add((DataCollectorConfiguration)new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.SYNCHRONIZATION));
        result.add((DataCollectorConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.SYNC));
        DTDCConfiguration dataCollectorConfiguration = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(rawTableMetadata));
        dataCollectorConfiguration.setStackSupportEnabled(true);
        dataCollectorConfiguration.setIndicatorFiringFactor(1);
        dataCollectorConfiguration.setOutputPrefix("sync:");
        result.add((DataCollectorConfiguration)dataCollectorConfiguration);
        return result;
    }

    private IndicatorConfiguration initIndicatorConfiguration() {
        IndicatorMetadata indicatorMetadata = null;
        ArrayList<DataTableMetadata.Column> indicatorColumns = new ArrayList<DataTableMetadata.Column>();
        indicatorColumns.add(locksColumn);
        indicatorColumns.add(threadsColumn);
        indicatorColumns.add(SunStudioDCConfiguration.c_ulockSummary);
        indicatorColumns.add(ProcDataProviderConfiguration.THREADS);
        indicatorColumns.addAll(LLDataCollectorConfiguration.SYNC_TABLE.getColumns());
        indicatorMetadata = new IndicatorMetadata(indicatorColumns);
        TimeSeriesIndicatorConfiguration indicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 300);
        indicatorConfiguration.setPersistencePrefix("dlight_sync");
        indicatorConfiguration.setTitle(SyncToolConfigurationProvider.loc("indicator.title", new String[0]));
        indicatorConfiguration.setGraphScale(2);
        TimeSeriesDescriptor threadsDesciptor = new TimeSeriesDescriptor("threads", SyncToolConfigurationProvider.loc("graph.description.threads", new String[0]), new Color(178, 188, 0), TimeSeriesDescriptor.Kind.ABS_SURFACE);
        TimeSeriesDescriptor syncDescriptor = new TimeSeriesDescriptor("locks", SyncToolConfigurationProvider.loc("graph.description.locks", new String[0]), new Color(231, 111, 0), TimeSeriesDescriptor.Kind.ABS_SURFACE);
        List<DataTableMetadata.Column> threadColumnsList = Arrays.asList(threadsColumn, ProcDataProviderConfiguration.THREADS, LLDataCollectorConfiguration.threads_count);
        List<DataTableMetadata.Column> lockColumnsList = Arrays.asList(locksColumn, SunStudioDCConfiguration.c_ulockSummary, LLDataCollectorConfiguration.LOCKS_COUNT);
        threadsDesciptor.setSourceColumns(threadColumnsList);
        syncDescriptor.setSourceColumns(lockColumnsList);
        indicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{threadsDesciptor, syncDescriptor});
        indicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToSync(threadColumnsList, lockColumnsList));
        indicatorConfiguration.setActionDisplayName(SyncToolConfigurationProvider.loc("indicator.action", new String[0]));
        indicatorConfiguration.setActionTooltip(SyncToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        indicatorConfiguration.addVisualizerConfiguration(this.getDetails(rawTableMetadata));
        DataTableMetadata detailedViewTableMetadata = SunStudioDCConfiguration.getSyncTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn});
        FunctionDatatableDescription functionDesc = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
        FunctionsListViewVisualizerConfiguration tableVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(detailedViewTableMetadata, functionDesc, Arrays.asList(SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn));
        ColumnsUIMapping uiMapping = new ColumnsUIMapping();
        uiMapping.setColumnUI(SunStudioDCConfiguration.c_name.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.func_name", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.func_name", new String[0]));
        uiMapping.setColumnUI(SunStudioDCConfiguration.c_eSync.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.e_sync", new String[0]));
        uiMapping.setColumnUI(SunStudioDCConfiguration.c_eSyncn.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.syncn", new String[0]));
        tableVisualizerConfiguration.setColumnsUIMapping(uiMapping);
        tableVisualizerConfiguration.setEmptyAnalyzeMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        tableVisualizerConfiguration.setEmptyRunningMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        indicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)tableVisualizerConfiguration);
        return indicatorConfiguration;
    }

    private List<IndicatorDataProviderConfiguration> initIndicatorDataProviderConfigurations() {
        ArrayList<IndicatorDataProviderConfiguration> lockIndicatorDataProviders = new ArrayList<IndicatorDataProviderConfiguration>();
        DataTableMetadata indicatorTableMetadata = new DataTableMetadata("locks", Arrays.asList(locksColumn, threadsColumn), null);
        List<DataTableMetadata> indicatorTablesMetadata = Arrays.asList(indicatorTableMetadata);
        CLIODCConfiguration lockConf = new CLIODCConfiguration("/bin/prstat", "-mv -p @PID -c 1", (CLIOParser)new SyncCLIOParser(locksColumn, threadsColumn), indicatorTablesMetadata);
        lockConf.setName("prstat");
        lockIndicatorDataProviders.add((IndicatorDataProviderConfiguration)lockConf);
        lockIndicatorDataProviders.add((IndicatorDataProviderConfiguration)new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY));
        lockIndicatorDataProviders.add((IndicatorDataProviderConfiguration)new ProcDataProviderConfiguration());
        lockIndicatorDataProviders.add((IndicatorDataProviderConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.SYNC));
        return lockIndicatorDataProviders;
    }

    private VisualizerConfiguration getDetails(DataTableMetadata rawTableMetadata) {
        DataTableMetadata viewTableMetadata = null;
        DataTableMetadata.Column syncTimeColumn = new DataTableMetadata.Column("time", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), null);
        DataTableMetadata.Column syncCountColumn = new DataTableMetadata.Column("count", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), null);
        List<DataTableMetadata.Column> viewColumns = Arrays.asList(new DataTableMetadata.Column("id", Integer.class, "id", null), new DataTableMetadata.Column("func_name", FunctionName.class, "Function", null), syncTimeColumn, syncCountColumn);
        String sql = "SELECT func.func_id as id, func.func_name as func_name, node.offset as offset, SUM(sync.time/1000000) as time, COUNT(*) as count FROM sync, node AS node, func WHERE  sync.stackid = node.node_id and node.func_id = func.func_id GROUP BY node.func_id, func.func_id, func.func_name, node.offset";
        viewTableMetadata = new DataTableMetadata("sync", viewColumns, sql, Arrays.asList(rawTableMetadata));
        FunctionDatatableDescription functionDesc = new FunctionDatatableDescription("func_name", "offset", "id");
        FunctionsListViewVisualizerConfiguration tableVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(viewTableMetadata, functionDesc, Arrays.asList(syncTimeColumn, syncCountColumn));
        ColumnsUIMapping uiMapping = new ColumnsUIMapping();
        uiMapping.setColumnUI("func_name", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.func_name", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.func_name", new String[0]));
        uiMapping.setColumnUI("time", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.e_sync", new String[0]));
        uiMapping.setColumnUI("count", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.syncn", new String[0]));
        tableVisualizerConfiguration.setColumnsUIMapping(uiMapping);
        tableVisualizerConfiguration.setEmptyAnalyzeMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        tableVisualizerConfiguration.setEmptyRunningMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        return tableVisualizerConfiguration;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(SyncToolConfigurationProvider.class, (String)key, (Object[])params);
    }

    static {
        List<DataTableMetadata.Column> rawColumns = Arrays.asList(timestampColumn, waiterColumn, mutexColumn, blockerColumn, timeColumn, stackColumn);
        rawTableMetadata = new DataTableMetadata("sync", rawColumns, null);
    }

    private static final class DataRowToSync
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> threadColumns;
        private final List<DataTableMetadata.Column> lockColumns;
        private int locks;

        public DataRowToSync(List<DataTableMetadata.Column> threadColumns, List<DataTableMetadata.Column> lockColumns) {
            this.threadColumns = new ArrayList<DataTableMetadata.Column>(threadColumns);
            this.lockColumns = new ArrayList<DataTableMetadata.Column>(lockColumns);
        }

        public float[] getData(DataRow row) {
            boolean success = false;
            int threads = 0;
            for (String columnName : row.getColumnNames()) {
                for (DataTableMetadata.Column threadColumn : this.threadColumns) {
                    if (!threadColumn.getColumnName().equals(columnName)) continue;
                    success = true;
                    threads = DataUtil.toInt((Object)row.getData(columnName));
                }
                for (DataTableMetadata.Column lockColumn : this.lockColumns) {
                    if (!lockColumn.getColumnName().equals(columnName)) continue;
                    this.locks = DataUtil.toInt((Object)row.getData(columnName));
                }
            }
            if (success) {
                return new float[]{threads, (float)(threads * Math.min(this.locks, 100)) / 100.0f};
            }
            return null;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }

    private static class SyncCLIOParser
    implements CLIOParser {
        private static final Pattern TOTAL = Pattern.compile("^Total: \\d+ processes, (\\d+) lwps");
        private final List<String> colnames;
        private float locks;
        private boolean nextLineShouldBeTotal;

        public SyncCLIOParser(DataTableMetadata.Column locksColumn, DataTableMetadata.Column threadsColumn) {
            this.colnames = Arrays.asList(locksColumn.getColumnName(), threadsColumn.getColumnName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataRow process(String line) {
            Matcher m;
            if (DLightLogger.instance.isLoggable(Level.FINE)) {
                DLightLogger.instance.fine("SyncCLIOParser: " + line);
            }
            if (line == null || line.length() == 0) {
                return null;
            }
            if (Character.isDigit((line = line.trim()).charAt(0))) {
                String[] tokens = (line = line.replaceAll(",", ".")).split("[ \t]+");
                if (tokens.length < 8) {
                    return null;
                }
                try {
                    this.locks = Float.parseFloat(tokens[7]);
                    this.nextLineShouldBeTotal = true;
                }
                catch (NumberFormatException ex) {}
            } else if (this.nextLineShouldBeTotal && (m = TOTAL.matcher(line)).find()) {
                try {
                    int threads = Integer.parseInt(m.group(1));
                    DataRow dataRow = new DataRow(this.colnames, Arrays.asList(Float.valueOf(this.locks), threads));
                    return dataRow;
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    this.nextLineShouldBeTotal = false;
                }
            }
            return null;
        }
    }
}

