/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.modules.j2ee.common.project.FileChangeSupport;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportEvent;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class ArtifactCopyOnSaveSupport
implements FileChangeSupportListener,
PropertyChangeListener,
AntProjectListener {
    private static final Logger LOGGER = Logger.getLogger(ArtifactCopyOnSaveSupport.class.getName());
    private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();
    private final Map<File, String> listeningTo = new HashMap<File, String>();
    private final String destDirProperty;
    private final PropertyEvaluator evaluator;
    private final AntProjectHelper antHelper;
    private boolean synchronize;
    private volatile String destDir;

    public ArtifactCopyOnSaveSupport(String string, PropertyEvaluator propertyEvaluator, AntProjectHelper antProjectHelper) {
        this.destDirProperty = string;
        this.evaluator = propertyEvaluator;
        this.antHelper = antProjectHelper;
    }

    public synchronized void enableArtifactSynchronization(boolean bl) {
        this.synchronize = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addArtifactListener(ArtifactListener artifactListener) {
        if (artifactListener == null) {
            return;
        }
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            boolean bl = this.listeners.isEmpty();
            this.listeners.add(artifactListener);
            if (bl) {
                this.initialize();
                this.reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeArtifactListener(ArtifactListener artifactListener) {
        if (artifactListener == null) {
            return;
        }
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            this.listeners.remove(artifactListener);
            if (this.listeners.isEmpty()) {
                this.close();
            }
        }
    }

    public final void initialize() {
        this.close();
        this.destDir = this.evaluator.getProperty(this.destDirProperty);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.antHelper.addAntProjectListener((AntProjectListener)this);
    }

    protected abstract Map<ClassPathSupport.Item, String> getArtifacts();

    protected ArtifactListener.Artifact filterArtifact(ArtifactListener.Artifact artifact) {
        return artifact;
    }

    public final synchronized void reload() {
        HashMap<File, String> hashMap = new HashMap<File, String>(this.listeningTo);
        for (Map.Entry<ClassPathSupport.Item, String> entry : this.getArtifacts().entrySet()) {
            String string;
            ClassPathSupport.Item item = entry.getKey();
            if (item.isBroken() || item.getType() != 2 || item.getArtifact().getProject().getLookup().lookup(J2eeModuleProvider.class) != null) continue;
            File file = item.getArtifact().getScriptLocation().getAbsoluteFile();
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if ((string = entry.getValue()) == null) continue;
            for (URI uRI : item.getArtifact().getArtifactLocations()) {
                File file2 = null;
                file2 = uRI.isAbsolute() ? new File(uRI) : new File(file, uRI.getPath());
                if (!this.listeningTo.containsKey(file2 = FileUtil.normalizeFile((File)file2))) {
                    FileChangeSupport.DEFAULT.addListener(this, file2);
                    this.listeningTo.put(file2, string);
                    if (this.synchronize) {
                        try {
                            this.updateFile(file2, string);
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.FINE, "Initial copy failed", iOException);
                        }
                    }
                }
                hashMap.remove(file2);
            }
        }
        for (Map.Entry<Object, String> entry : hashMap.entrySet()) {
            FileChangeSupport.DEFAULT.removeListener(this, (File)entry.getKey());
            this.listeningTo.remove(entry.getKey());
            if (!this.synchronize) continue;
            this.deleteFile((File)entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            for (Map.Entry<File, String> entry : this.listeningTo.entrySet()) {
                FileChangeSupport.DEFAULT.removeListener(this, entry.getKey());
            }
            this.listeningTo.clear();
        }
        this.antHelper.removeAntProjectListener((AntProjectListener)this);
        this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("javac.classpath".equals(propertyChangeEvent.getPropertyName())) {
            LOGGER.log(Level.FINEST, "Classpath changed");
            this.reload();
        } else if (this.destDirProperty.equals(propertyChangeEvent.getPropertyName())) {
            this.destDir = this.evaluator.getProperty(this.destDirProperty);
        }
    }

    public final void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if ("nbproject/project.xml".equals(antProjectEvent.getPath())) {
            LOGGER.log(Level.FINEST, "Project XML changed");
            this.reload();
        }
    }

    public final void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    @Override
    public final void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
        this.updateFile(fileChangeSupportEvent);
    }

    @Override
    public final void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
        this.updateFile(fileChangeSupportEvent);
    }

    @Override
    public final void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireArtifactChange(File file) {
        ArrayList<ArtifactListener> arrayList = null;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<ArtifactListener>(this.listeners);
        }
        object = Collections.singleton(this.filterArtifact(ArtifactListener.Artifact.forFile((File)file).referencedLibrary()));
        for (ArtifactListener artifactListener : arrayList) {
            artifactListener.artifactsUpdated((Iterable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(FileChangeSupportEvent fileChangeSupportEvent) {
        File file = null;
        String string = null;
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            file = FileUtil.normalizeFile((File)fileChangeSupportEvent.getPath());
            string = this.listeningTo.get(fileChangeSupportEvent.getPath());
            if (string == null) {
                return;
            }
        }
        try {
            this.updateFile(file, string);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
    }

    private void updateFile(File file, String string) throws IOException {
        FileObject fileObject;
        assert (file != null);
        assert (string != null);
        FileObject fileObject2 = fileObject = this.destDir == null ? null : this.antHelper.resolveFileObject(this.destDir);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject3 = FileUtil.toFileObject((File)file);
        if (fileObject3 == null) {
            LOGGER.log(Level.FINE, "Source file does not exist");
            return;
        }
        FileObject fileObject4 = FileUtil.createData((FileObject)fileObject, (String)(string + "/" + fileObject3.getNameExt()));
        this.copy(fileObject3, fileObject4);
        File file2 = FileUtil.toFile((FileObject)fileObject4);
        if (file2 != null) {
            this.fireArtifactChange(file2);
        }
        LOGGER.log(Level.FINE, "Artifact jar successfully copied " + file.getAbsolutePath() + " " + file.length());
    }

    private void deleteFile(File file, String string) {
        File file2;
        FileObject fileObject;
        block9: {
            FileObject fileObject2;
            assert (file != null);
            assert (string != null);
            FileObject fileObject3 = fileObject2 = this.destDir == null ? null : this.antHelper.resolveFileObject(this.destDir);
            if (fileObject2 == null) {
                return;
            }
            fileObject = null;
            try {
                fileObject = FileUtil.createData((FileObject)fileObject2, (String)(string + "/" + file.getName()));
                if (fileObject == null) {
                    return;
                }
                fileObject.delete();
                LOGGER.log(Level.FINE, "Artifact jar successfully deleted");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
                if (!"jar".equals(fileObject.getExt())) break block9;
                try {
                    this.zeroOutArchive(fileObject);
                    LOGGER.log(Level.FINE, "Artifact jar successfully zeroed out");
                }
                catch (IOException iOException2) {
                    LOGGER.log(Level.INFO, "Could not zero out archive", iOException2);
                }
            }
        }
        if (fileObject != null && (file2 = FileUtil.toFile((FileObject)fileObject)) != null) {
            this.fireArtifactChange(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(FileObject fileObject, FileObject fileObject2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        FileLock fileLock = null;
        try {
            inputStream = fileObject.getInputStream();
            fileLock = fileObject2.lock();
            outputStream = fileObject2.getOutputStream(fileLock);
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroOutArchive(FileObject fileObject) throws IOException {
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
            try {
                jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                jarOutputStream.write("Manifest-Version: 1.0\n".getBytes("UTF-8"));
            }
            finally {
                jarOutputStream.close();
            }
        }
        finally {
            outputStream.close();
        }
    }
}

