/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.sftp.SftpClient;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.sftp.SftpConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class SftpConnectionProvider
implements RemoteConnectionProvider {
    private static final String SFTP_CONNECTION_TYPE = "SFTP";
    private static final SshFiles UNKNOWN_SSH_FILES = new SshFiles();
    static final String TYPE = "type";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String KNOWN_HOSTS_FILE = "knownHostsFile";
    static final String IDENTITY_FILE = "identityFile";
    static final String PASSWORD = "password";
    static final String INITIAL_DIRECTORY = "initialDirectory";
    static final String TIMEOUT = "timeout";
    private static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("type", "host", "port", "user", "password", "knownHostsFile", "identityFile", "initialDirectory", "timeout"));
    private static final int DEFAULT_PORT = 22;
    private static final int DEFAULT_TIMEOUT = 30;
    private static final String DEFAULT_INITIAL_DIRECTORY = "/var/www";

    private SftpConnectionProvider() {
    }

    public static SftpConnectionProvider get() {
        return new SftpConnectionProvider();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SftpConnectionProvider.class, (String)"LBL_Sftp");
    }

    @Override
    public Set<String> getPropertyNames() {
        return PROPERTIES;
    }

    @Override
    public RemoteConfiguration createRemoteConfiguration(ConfigManager.Configuration configuration) {
        SshFiles sshFiles = this.getDefaultSshFiles();
        configuration.putValue(TYPE, SFTP_CONNECTION_TYPE);
        configuration.putValue(HOST, "");
        configuration.putValue(PORT, String.valueOf(22));
        configuration.putValue(USER, "");
        configuration.putValue(PASSWORD, "");
        configuration.putValue(KNOWN_HOSTS_FILE, sshFiles.getKnownHostsFile());
        configuration.putValue(IDENTITY_FILE, sshFiles.getIdentityFile());
        configuration.putValue(INITIAL_DIRECTORY, DEFAULT_INITIAL_DIRECTORY);
        configuration.putValue(TIMEOUT, String.valueOf(30));
        assert (this.accept(configuration)) : "Not my configuration?!";
        return new SftpConfiguration(configuration);
    }

    @Override
    public RemoteConfiguration getRemoteConfiguration(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new SftpConfiguration(configuration);
        }
        return null;
    }

    @Override
    public RemoteClient getRemoteClient(RemoteConfiguration remoteConfiguration, InputOutput io) {
        if (remoteConfiguration instanceof SftpConfiguration) {
            return new SftpClient((SftpConfiguration)remoteConfiguration, io);
        }
        return null;
    }

    @Override
    public RemoteConfigurationPanel getRemoteConfigurationPanel(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new SftpConfigurationPanel();
        }
        return null;
    }

    private boolean accept(ConfigManager.Configuration configuration) {
        String type = configuration.getValue(TYPE);
        return SFTP_CONNECTION_TYPE.equals(type);
    }

    private SshFiles getDefaultSshFiles() {
        if (Utilities.isWindows()) {
            return this.getDefaultWindowsSshFiles();
        }
        if (Utilities.isUnix()) {
            return this.getDefaultUnixSshFiles();
        }
        return UNKNOWN_SSH_FILES;
    }

    private SshFiles getDefaultUnixSshFiles() {
        String identityFile = "";
        String knownHostsFile = "";
        File sshDir = new File(System.getProperty("user.home"), ".ssh");
        File dsaKey = new File(sshDir, "id_dsa");
        File rsaKey = new File(sshDir, "id_rsa");
        if (dsaKey.isFile()) {
            identityFile = dsaKey.getAbsolutePath();
        } else if (rsaKey.isFile()) {
            identityFile = rsaKey.getAbsolutePath();
        }
        File knownHosts = new File(sshDir, "known_hosts");
        if (knownHosts.isFile()) {
            knownHostsFile = knownHosts.getAbsolutePath();
        }
        return new SshFiles(identityFile, knownHostsFile);
    }

    private SshFiles getDefaultWindowsSshFiles() {
        return UNKNOWN_SSH_FILES;
    }

    private static final class SshFiles {
        private final String identityFile;
        private final String knownHostsFile;

        public SshFiles() {
            this("", "");
        }

        public SshFiles(String identityFile, String knownHostsFile) {
            assert (identityFile != null);
            assert (knownHostsFile != null);
            this.identityFile = identityFile;
            this.knownHostsFile = knownHostsFile;
        }

        public String getIdentityFile() {
            return this.identityFile;
        }

        public String getKnownHostsFile() {
            return this.knownHostsFile;
        }
    }
}

