/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class SourceRoots {
    public static final String PROP_ROOTS = SourceRoots.class.getName() + ".roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final List<String> sourceRootProperties;
    private final List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final File projectDir;
    private final Type type;

    public static SourceRoots create(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, Type type) {
        assert (helper != null);
        assert (evaluator != null);
        assert (refHelper != null);
        assert (type != null);
        return new SourceRoots(helper, evaluator, refHelper, type);
    }

    private SourceRoots(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, Type type) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.type = type;
        switch (type) {
            case SOURCES: {
                this.sourceRootProperties = Arrays.asList("src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_Sources"));
                break;
            }
            case TESTS: {
                this.sourceRootProperties = Arrays.asList("test.src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_Tests"));
                break;
            }
            case SELENIUM: {
                this.sourceRootProperties = Arrays.asList("selenium.src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_SeleniumTests"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknow sources roots type: " + (Object)((Object)type));
            }
        }
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
    }

    public String[] getRootNames() {
        return this.sourceRootNames.toArray(new String[this.sourceRootNames.size()]);
    }

    public String[] getRootProperties() {
        return this.sourceRootProperties.toArray(new String[this.sourceRootProperties.size()]);
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] srcProps = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> result = new ArrayList<FileObject>();
                        for (String p : srcProps) {
                            FileObject f;
                            String prop = SourceRoots.this.evaluator.getProperty(p);
                            if (prop == null || (f = SourceRoots.this.helper.getAntProjectHelper().resolveFileObject(prop)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)f)) {
                                f = FileUtil.getArchiveRoot((FileObject)f);
                            }
                            result.add(f);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(result);
                    }
                    return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
                }
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        ArrayList<URL> result = new ArrayList<URL>();
                        for (String srcProp : SourceRoots.this.getRootProperties()) {
                            String prop = SourceRoots.this.evaluator.getProperty(srcProp);
                            if (prop == null) continue;
                            File f = SourceRoots.this.helper.getAntProjectHelper().resolveFile(prop);
                            try {
                                URL url = f.toURI().toURL();
                                if (!f.exists()) {
                                    url = new URL(url.toExternalForm() + "/");
                                } else if (f.isFile()) continue;
                                assert (url.toExternalForm().endsWith("/")) : "#90639 violation for " + url + "; " + f + " exists? " + f.exists() + " dir? " + f.isDirectory() + " file? " + f.isFile();
                                result.add(url);
                            }
                            catch (MalformedURLException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(result);
                    }
                    return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String getRootDisplayName(String rootName, String propName) {
        if (rootName == null || rootName.length() == 0) {
            switch (this.type) {
                case SOURCES: {
                    rootName = DEFAULT_SOURCE_LABEL;
                    break;
                }
                case TESTS: {
                    rootName = DEFAULT_TEST_LABEL;
                    break;
                }
                default: {
                    String propValue = this.evaluator.getProperty(propName);
                    File sourceRoot = propValue == null ? null : this.helper.getAntProjectHelper().resolveFile(propValue);
                    rootName = this.createInitialDisplayName(sourceRoot);
                }
            }
        }
        return rootName;
    }

    public String createInitialDisplayName(File sourceRoot) {
        return SourceRoots.createInitialDisplayName(sourceRoot, this.projectDir, this.type);
    }

    public static String createInitialDisplayName(File sourceRoot, File projectDir, Type type) {
        String pdPath;
        String srPath;
        String rootName = sourceRoot != null ? ((srPath = sourceRoot.getAbsolutePath()).startsWith(pdPath = projectDir.getAbsolutePath() + File.separatorChar) ? srPath.substring(pdPath.length()) : sourceRoot.getAbsolutePath()) : (type.equals((Object)Type.SOURCES) ? DEFAULT_SOURCE_LABEL : DEFAULT_TEST_LABEL);
        return rootName;
    }

    public boolean isTest() {
        boolean isTest = false;
        switch (this.type) {
            case SOURCES: {
                isTest = false;
                break;
            }
            case TESTS: 
            case SELENIUM: {
                isTest = true;
                break;
            }
            default: {
                assert (false) : "Unknown source roots type: " + (Object)((Object)this.type);
                break;
            }
        }
        return isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(String propName) {
        boolean fire = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (propName == null || this.sourceRootProperties.contains(propName)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                fire = true;
            }
        }
        if (fire) {
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    public void fireChange() {
        this.resetCache(null);
    }

    private final class ProjectMetadataListener
    implements PropertyChangeListener {
        private ProjectMetadataListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourceRoots.this.resetCache(evt.getPropertyName());
        }
    }

    public static enum Type {
        SOURCES,
        TESTS,
        SELENIUM;

    }
}

