/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.AddUseImportRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.util.NbBundle;

public class TypeRedeclaration
extends AbstractRule {
    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        Collection<? extends TypeScope> declaredTypes = ModelUtils.getDeclaredTypes(fileScope);
        HashSet<String> typeNames = new HashSet<String>();
        for (TypeScope typeScope : declaredTypes) {
            QualifiedName qualifiedName = typeScope.getNamespaceName().append(typeScope.getName()).toFullyQualified();
            String name = qualifiedName.toString();
            if (typeNames.contains(name)) continue;
            typeNames.add(name);
            List<? extends TypeScope> instances = ModelUtils.filter(declaredTypes, qualifiedName);
            if (instances.size() <= 1) continue;
            TypeScope firstDeclaredInstance = null;
            for (TypeScope typeScope2 : instances) {
                if (firstDeclaredInstance == null) {
                    firstDeclaredInstance = typeScope2;
                    continue;
                }
                if (firstDeclaredInstance.getOffset() <= typeScope2.getOffset()) continue;
                firstDeclaredInstance = typeScope2;
            }
            for (TypeScope typeScope3 : instances) {
                if (typeScope3 == firstDeclaredInstance) continue;
                hints.add(new Hint((Rule)this, this.getDescription(), context.parserResult.getSnapshot().getSource().getFileObject(), typeScope3.getNameRange(), Collections.emptyList(), 500));
            }
        }
    }

    public String getId() {
        return "Type.Redeclaration.Rule";
    }

    public String getDescription() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"TypeRedeclarationRuleDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"TypeRedeclarationRuleDispName");
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }
}

