/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RestArgNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsNode
extends Node {
    private ListNode pre;
    private ListNode optional;
    private ListNode post;
    protected ArgumentNode rest;
    private BlockArgNode block;

    public ArgsNode(SourcePosition position, ListNode pre, ListNode optional, RestArgNode rest, ListNode post, BlockArgNode block) {
        super(position);
        this.pre = pre;
        this.optional = optional;
        this.post = post;
        this.rest = rest;
        this.block = block;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getOptionalCount() {
        return this.optional == null ? 0 : this.optional.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public int getRequiredCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public int getMaxArgumentsCount() {
        return this.getRequiredCount() + this.getOptionalCount();
    }

    public ListNode getOptional() {
        return this.optional;
    }

    public ListNode getPost() {
        return this.post;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public ArgumentNode getRest() {
        return this.rest;
    }

    public BlockArgNode getBlock() {
        return this.block;
    }

    @Override
    public List<Node> childNodes() {
        if (this.post != null) {
            return Node.createList(this.pre, this.optional, this.rest, this.post, this.block);
        }
        return Node.createList(this.pre, this.optional, this.rest, this.block);
    }
}

