/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes.actions;

import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.UndeployModuleCookie;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UndeployModuleCookieImpl
implements UndeployModuleCookie {
    private String fileName;
    private Lookup lookup;
    private ModuleType type;
    private final boolean isEJB3;
    private boolean isRunning;

    public UndeployModuleCookieImpl(String string, ModuleType moduleType, Lookup lookup) {
        this(string, moduleType, false, lookup);
    }

    public UndeployModuleCookieImpl(String string, Lookup lookup) {
        this(string, ModuleType.EJB, true, lookup);
    }

    private UndeployModuleCookieImpl(String string, ModuleType moduleType, boolean bl, Lookup lookup) {
        this.lookup = lookup;
        this.fileName = string;
        this.type = moduleType;
        this.isEJB3 = bl;
        this.isRunning = false;
    }

    @Override
    public RequestProcessor.Task undeploy() {
        final JBDeploymentManager jBDeploymentManager = (JBDeploymentManager)this.lookup.lookup(JBDeploymentManager.class);
        final String string = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UndeployModuleCookieImpl.class, (String)"LBL_UndeployProgress", (Object)string));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UndeployModuleCookieImpl.this.isRunning = true;
                String string2 = jBDeploymentManager.getInstanceProperties().getProperty("deploy-dir");
                File file = new File(string2, UndeployModuleCookieImpl.this.fileName);
                if (file.exists() && file.canWrite()) {
                    file.delete();
                    try {
                        ObjectName objectName = null;
                        if (Util.isRemoteManagementSupported(UndeployModuleCookieImpl.this.lookup) && !UndeployModuleCookieImpl.this.isEJB3) {
                            objectName = new ObjectName("jboss.management.local:" + (!UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR) ? "J2EEApplication=null," : "") + "j2eeType=" + Util.getModuleTypeString(UndeployModuleCookieImpl.this.type) + ",name=" + UndeployModuleCookieImpl.this.fileName + ",*");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR)) {
                            objectName = new ObjectName("jboss.j2ee:service=EARDeployment,url='" + UndeployModuleCookieImpl.this.fileName + "'");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.WAR)) {
                            objectName = new ObjectName("jboss.web:j2eeType=WebModule,J2EEApplication=none,name=//localhost/" + string + ",*");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EJB)) {
                            objectName = new ObjectName("jboss.j2ee:service=" + (UndeployModuleCookieImpl.this.isEJB3 ? "EJB3" : "EjbModule") + ",module=" + UndeployModuleCookieImpl.this.fileName);
                        }
                        int n = 0;
                        while (jBDeploymentManager.refreshRMIServer() != null && Util.isObjectDeployed(jBDeploymentManager.getRMIServer(), objectName) && n < 30000) {
                            try {
                                Thread.sleep(2000L);
                                n += 2000;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                progressHandle.finish();
                UndeployModuleCookieImpl.this.isRunning = false;
            }
        };
        progressHandle.start();
        return RequestProcessor.getDefault().post(runnable);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

