/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InVmSequenceData
implements SequenceData {
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final String sequenceId;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageNumber;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private final Collection<Long> allUnackedMessageNumbers;
    private final Collection<Long> receivedUnackedMessageNumbers;
    private final Map<String, ApplicationMessage> weakMessageStorage;
    private final Map<Long, String> weakUnackedNumberToCorrelationIdMap;
    private final TimeSynchronizer timeSynchronizer;

    public InVmSequenceData(TimeSynchronizer timeSynchronizer, String sequenceId, String securityContextTokenId, long expirationTime, long lastMessageId, long lastActivityTime) {
        this(timeSynchronizer, sequenceId, securityContextTokenId, expirationTime, Sequence.State.CREATED, false, lastMessageId, lastActivityTime, 0L);
    }

    public InVmSequenceData(TimeSynchronizer timeSynchronizer, String sequenceId, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) {
        this.timeSynchronizer = timeSynchronizer;
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.state = state;
        this.ackRequestedFlag = ackRequestedFlag;
        this.lastMessageNumber = lastMessageId;
        this.lastActivityTime = lastActivityTime;
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
        this.allUnackedMessageNumbers = new TreeSet<Long>();
        this.receivedUnackedMessageNumbers = new HashSet<Long>();
        this.weakMessageStorage = new WeakHashMap<String, ApplicationMessage>();
        this.weakUnackedNumberToCorrelationIdMap = new WeakHashMap<Long, String>();
    }

    private void lockRead() {
        this.dataLock.readLock().lock();
    }

    private void unlockRead() {
        this.dataLock.readLock().unlock();
    }

    private void lockWrite() {
        this.dataLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.dataLock.writeLock().unlock();
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMessageNumber() {
        try {
            this.lockRead();
            long l = this.lastMessageNumber;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Sequence.State getState() {
        return this.state;
    }

    @Override
    public void setState(Sequence.State newState) {
        this.updateLastActivityTime();
        this.state = newState;
    }

    @Override
    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        this.updateLastActivityTime();
        this.ackRequestedFlag = newValue;
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newTime) {
        this.updateLastActivityTime();
        this.lastAcknowledgementRequestTime = newTime;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    private void updateLastActivityTime() {
        this.lastActivityTime = this.timeSynchronizer.currentTimeInMillis();
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            String correlationKey = new String(message.getCorrelationId());
            Long msgNumberKey = this.getUnackedMessageIdentifierKey(message.getMessageNumber());
            this.weakUnackedNumberToCorrelationIdMap.put(msgNumberKey, correlationKey);
            this.weakMessageStorage.put(correlationKey, message);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementAndGetLastMessageNumber(boolean received) {
        this.updateLastActivityTime();
        try {
            this.dataLock.writeLock().lock();
            this.addUnackedMessageNumber(++this.lastMessageNumber, received);
            long l = this.lastMessageNumber;
            return l;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUnackedMessageNumber(long messageNumber, boolean received) throws DuplicateMessageRegistrationException {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            if (messageNumber > this.lastMessageNumber) {
                while (messageNumber > this.lastMessageNumber + 1L) {
                    this.incrementAndGetLastMessageNumber(false);
                }
                this.incrementAndGetLastMessageNumber(received);
            } else {
                if (received && this.receivedUnackedMessageNumbers.contains(messageNumber) || !received && this.allUnackedMessageNumbers.contains(messageNumber)) {
                    throw new DuplicateMessageRegistrationException(this.sequenceId, messageNumber);
                }
                this.addUnackedMessageNumber(messageNumber, received);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    private void addUnackedMessageNumber(long messageNumber, boolean received) {
        Long newUnackedInstance = new Long(messageNumber);
        this.allUnackedMessageNumbers.add(newUnackedInstance);
        if (received) {
            this.receivedUnackedMessageNumbers.add(newUnackedInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsAcknowledged(long messageNumber) {
        this.updateLastActivityTime();
        try {
            this.lockWrite();
            this.receivedUnackedMessageNumbers.remove(messageNumber);
            this.allUnackedMessageNumbers.remove(messageNumber);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        this.updateLastActivityTime();
        try {
            this.lockRead();
            ApplicationMessage applicationMessage = this.weakMessageStorage.get(correlationId);
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getUnackedMessageNumbers() {
        try {
            this.lockRead();
            ArrayList<Long> arrayList = new ArrayList<Long>(this.allUnackedMessageNumbers);
            return arrayList;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getLastMessageNumberWithUnackedMessageNumbers() {
        try {
            this.lockRead();
            LinkedList<Long> data = new LinkedList<Long>(this.allUnackedMessageNumbers);
            data.addFirst(this.lastMessageNumber);
            LinkedList<Long> linkedList = data;
            return linkedList;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getUnackedMessageIdentifierKey(long messageNumber) {
        try {
            this.lockRead();
            Long msgNumberKey2 = null;
            for (Long msgNumberKey2 : this.receivedUnackedMessageNumbers) {
                if (msgNumberKey2 == messageNumber) break;
            }
            Long l = msgNumberKey2;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }
}

