/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainScriptGenerator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

class CompilerSetScriptManager
extends RemoteConnectionSupport {
    private List<String> compilerSets = new ArrayList<String>();
    private int nextSet;
    private String platform;
    private Process process;

    public CompilerSetScriptManager(ExecutionEnvironment env) {
        super(env);
    }

    public boolean cancel() {
        Process aProcess = this.process;
        if (aProcess != null) {
            aProcess.destroy();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript() {
        if (!this.isFailedOrCancelled()) {
            this.nextSet = 0;
            this.compilerSets.clear();
            try {
                NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                HostInfo hinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                pb.setExecutable(hinfo.getShell()).setArguments(new String[]{"-s"});
                this.process = pb.call();
                this.process.getOutputStream().write(ToolchainScriptGenerator.generateScript(null).getBytes());
                this.process.getOutputStream().close();
                List lines = ProcessUtils.readProcessOutput((Process)this.process);
                int status = -1;
                try {
                    status = this.process.waitFor();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (status != 0) {
                    RemoteUtil.LOGGER.log(Level.WARNING, "CSSM.runScript: FAILURE {0}", status);
                    ProcessUtils.logError((Level)Level.ALL, (Logger)RemoteUtil.LOGGER, (Process)this.process);
                } else {
                    int i = 0;
                    for (String s : lines) {
                        RemoteUtil.LOGGER.log(Level.FINE, "CSSM.runScript line: {0}", s);
                        if (i == 0) {
                            this.platform = s;
                            RemoteUtil.LOGGER.log(Level.FINE, "    platform [{0}]", this.platform);
                        } else {
                            RemoteUtil.LOGGER.log(Level.FINE, "    line [{0}]", s);
                            this.compilerSets.add(s);
                        }
                        ++i;
                    }
                }
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "CSSM.runScript: IOException [{0}]", ex.getMessage());
                this.setFailed(ex.getMessage());
            }
            finally {
                this.process = null;
            }
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasMoreCompilerSets() {
        return this.nextSet < this.compilerSets.size();
    }

    public String getNextCompilerSetData() {
        return this.compilerSets.get(this.nextSet++);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String set : this.compilerSets) {
            buf.append(set).append('\n');
        }
        return buf.toString();
    }
}

