/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.util.TextUtils;

abstract class PopupItem {
    PopupItem() {
    }

    abstract void invoke();

    abstract String getDisplayText();

    static class IssueItem
    extends PopupItem {
        private Issue issue;

        public IssueItem(Issue issue) {
            this.issue = issue;
        }

        @Override
        void invoke() {
        }

        @Override
        String getDisplayText() {
            return IssueItem.getIssueDescription(this.issue);
        }

        public String highlite(String text, String displayText) {
            String textLower;
            if (text == null || text.trim().equals("")) {
                return displayText;
            }
            StringBuilder sb = new StringBuilder();
            text = TextUtils.escapeForHTMLLabel(text);
            String displayTextLower = (displayText = TextUtils.escapeForHTMLLabel(displayText)).toLowerCase();
            int idx = displayTextLower.indexOf(textLower = text.toLowerCase());
            if (idx < 0) {
                return displayText;
            }
            int lastIdx = 0;
            sb.append("<html><table width=10000>");
            while (idx > -1) {
                sb.append(displayText.substring(lastIdx, idx));
                lastIdx = idx + textLower.length();
                if (idx > -1) {
                    sb.append("<b>");
                    sb.append(displayText.substring(idx, lastIdx));
                    sb.append("</b>");
                }
                lastIdx = idx + textLower.length();
                idx = displayTextLower.indexOf(displayTextLower, lastIdx);
            }
            if (lastIdx < displayText.length()) {
                sb.append(displayText.substring(lastIdx, displayText.length()));
            }
            sb.append("</table></html>");
            return sb.toString();
        }

        public Issue getIssue() {
            return this.issue;
        }

        public static String getIssueDescription(Issue issue) {
            return issue.getID() + " - " + issue.getSummary();
        }
    }
}

