/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public abstract class GraphPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.graphs.Bundle");
    private static final String NO_DATA_TOOLTIP = messages.getString("GraphPanel_NoDataTooltip");
    private static final String MAX_VALUE_STRING = messages.getString("GraphPanel_MaxValueString");
    protected static final DateFormat DATE_FORMATTER;
    protected static final NumberFormat INT_FORMATTER;
    protected static final NumberFormat PERCENT_FORMATTER;
    protected static final double INITIAL_CHART_SCALEX = 0.02;
    protected static final long SMALL_CHART_FIT_TO_WINDOW_PERIOD = 180000L;
    private ProfilerXYTooltipModel tooltipModel;
    private SmallTooltip lastTooltip;
    private SmallTooltipManager smallTooltipManager;

    protected String getMaxValueString(String origString) {
        return MessageFormat.format(MAX_VALUE_STRING, origString);
    }

    protected ProfilerXYChart createChart(SynchronousXYItemsModel itemsModel, PaintersModel paintersModel, boolean smallPanel) {
        ProfilerXYChart chart;
        if (smallPanel) {
            chart = new ProfilerXYChart(itemsModel, paintersModel){

                public JToolTip createToolTip() {
                    GraphPanel.this.lastTooltip = new SmallTooltip(this);
                    return GraphPanel.this.lastTooltip;
                }

                public Point getToolTipLocation(MouseEvent e) {
                    return GraphPanel.getSmallTooltipLocation(e, GraphPanel.this.smallTooltipManager);
                }
            };
            this.smallTooltipManager = new SmallTooltipManager(chart);
            chart.setToolTipText(NO_DATA_TOOLTIP);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)chart));
        } else {
            chart = new ProfilerXYChart(itemsModel, paintersModel);
        }
        chart.getSelectionModel().setHoverMode(102);
        return chart;
    }

    public abstract Action[] getActions();

    protected ProfilerXYTooltipModel getTooltipModel() {
        if (this.tooltipModel == null) {
            this.tooltipModel = this.createTooltipModel();
        }
        return this.tooltipModel;
    }

    protected abstract ProfilerXYTooltipModel createTooltipModel();

    private static Point getSmallTooltipLocation(MouseEvent e, SmallTooltipManager tooltip) {
        Point p = e.getPoint();
        tooltip.setMousePosition(p);
        p.y += 25;
        return p;
    }

    static {
        String format = MessageFormat.format("{0}, {1}", TimeAxisUtils.TIME_MSEC, TimeAxisUtils.DATE_YEAR);
        DATE_FORMATTER = new SimpleDateFormat(format);
        INT_FORMATTER = NumberFormat.getIntegerInstance();
        INT_FORMATTER.setGroupingUsed(true);
        PERCENT_FORMATTER = NumberFormat.getPercentInstance();
        PERCENT_FORMATTER.setMinimumFractionDigits(1);
        PERCENT_FORMATTER.setMaximumIntegerDigits(2);
    }

    private class SmallTooltipManager
    implements ChartSelectionListener {
        private boolean timerRunning = false;
        private int mouseX;
        private int mouseY;
        private ProfilerXYChart chart;

        public SmallTooltipManager(ProfilerXYChart chart) {
            this.chart = chart;
            chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this);
        }

        public void setMousePosition(Point p) {
            this.mouseX = p.x;
            this.mouseY = p.y;
        }

        private void enableSelection() {
            this.chart.getSelectionModel().setHoverMode(102);
        }

        private void disableSelection() {
            if (this.timerRunning) {
                return;
            }
            this.timerRunning = true;
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SmallTooltipManager.this.isTooltipShowing()) {
                        SmallTooltipManager.this.chart.getSelectionModel().setHoverMode(100);
                        SmallTooltipManager.this.chart.setToolTipText(NO_DATA_TOOLTIP);
                    }
                    SmallTooltipManager.this.timerRunning = false;
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        private boolean isTooltipShowing() {
            return GraphPanel.this.lastTooltip != null && GraphPanel.this.lastTooltip.isShowing();
        }

        private void updateTooltipText(List<ItemSelection> selectedItems) {
            if (!this.isTooltipShowing()) {
                return;
            }
            if (selectedItems.isEmpty()) {
                this.chart.setToolTipText(NO_DATA_TOOLTIP);
            } else {
                this.chart.setToolTipText(this.getTooltipText(selectedItems));
            }
            MouseEvent e = new MouseEvent((Component)((Object)this.chart), 0, 0L, 0, this.mouseX, this.mouseY, 0, false);
            ToolTipManager.sharedInstance().mouseMoved(e);
        }

        private String getTooltipText(List<ItemSelection> selectedItems) {
            ProfilerXYTooltipModel model = GraphPanel.this.getTooltipModel();
            int rowsCount = model.getRowsCount();
            if (selectedItems.size() != rowsCount) {
                return "Rows and selected items don't match";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            XYItemSelection selection = (XYItemSelection)selectedItems.get(0);
            long timestamp = selection.getItem().getXValue(selection.getValueIndex());
            builder.append("&nbsp;&nbsp;");
            builder.append(model.getTimeValue(timestamp));
            builder.append("&nbsp;&nbsp;");
            builder.append("<hr>");
            for (int i = 0; i < rowsCount; ++i) {
                builder.append("<b>&nbsp;&nbsp;");
                builder.append(model.getRowName(i));
                builder.append(":</b>&nbsp;&nbsp;");
                XYItemSelection sel = (XYItemSelection)selectedItems.get(i);
                long itemValue = sel.getItem().getYValue(sel.getValueIndex());
                builder.append(model.getRowValue(i, itemValue));
                builder.append("&nbsp;");
                builder.append(model.getRowUnits(i, itemValue));
                builder.append("&nbsp;&nbsp;<br>");
            }
            int extraRowsCount = model.getExtraRowsCount();
            if (extraRowsCount > 0) {
                builder.append("<hr>");
            }
            for (int i = 0; i < extraRowsCount; ++i) {
                builder.append("<b>&nbsp;&nbsp;");
                builder.append(model.getExtraRowName(i));
                builder.append(":</b>&nbsp;&nbsp;");
                builder.append(model.getExtraRowValue(i));
                builder.append("&nbsp;");
                builder.append(model.getExtraRowUnits(i));
                builder.append("&nbsp;&nbsp;<br>");
            }
            builder.append("</html>");
            return builder.toString();
        }

        public void selectionModeChanged(int newMode, int oldMode) {
        }

        public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        }

        public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            this.updateTooltipText(currentItems);
        }

        public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        }
    }

    private class SmallTooltip
    extends JToolTip {
        public SmallTooltip(ProfilerXYChart chart) {
            this.setComponent((JComponent)((Object)chart));
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        if (SmallTooltip.this.isShowing()) {
                            GraphPanel.this.smallTooltipManager.enableSelection();
                        } else {
                            GraphPanel.this.smallTooltipManager.disableSelection();
                        }
                    }
                }
            });
        }
    }
}

