/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.HashMap;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;

public final class DesignEvent {
    private final long eventID;
    private final Set<DesignComponent> fullyComponents;
    private final Set<DesignComponent> partlyComponents;
    private final Set<DesignComponent> fullyHierarchies;
    private final Set<DesignComponent> partlyHierarchies;
    private Set<DesignComponent> descriptorChangedComponents;
    private Set<DesignComponent> createdComponents;
    private HashMap<DesignComponent, HashMap<String, PropertyValue>> oldPropertyValues;
    private boolean selectionChanged;
    private boolean structureChanged;

    DesignEvent(long eventID, Set<DesignComponent> fullyComponents, Set<DesignComponent> partlyComponents, Set<DesignComponent> fullyHierarchies, Set<DesignComponent> partlyHierarchies, Set<DesignComponent> descriptorChangedComponents, Set<DesignComponent> createdComponents, HashMap<DesignComponent, HashMap<String, PropertyValue>> oldPropertyValues, boolean selectionChanged) {
        this.eventID = eventID;
        this.fullyComponents = fullyComponents;
        this.partlyComponents = partlyComponents;
        this.fullyHierarchies = fullyHierarchies;
        this.partlyHierarchies = partlyHierarchies;
        this.descriptorChangedComponents = descriptorChangedComponents;
        this.createdComponents = createdComponents;
        this.oldPropertyValues = oldPropertyValues;
        this.selectionChanged = selectionChanged;
        this.structureChanged = !fullyComponents.isEmpty() || !partlyComponents.isEmpty() || !fullyHierarchies.isEmpty() || !partlyHierarchies.isEmpty() || !descriptorChangedComponents.isEmpty() || !createdComponents.isEmpty() || !oldPropertyValues.isEmpty();
    }

    public long getEventID() {
        return this.eventID;
    }

    public Set<DesignComponent> getFullyAffectedComponents() {
        return this.fullyComponents;
    }

    public Set<DesignComponent> getFullyAffectedHierarchies() {
        return this.fullyHierarchies;
    }

    public Set<DesignComponent> getPartlyAffectedComponents() {
        return this.partlyComponents;
    }

    public Set<DesignComponent> getPartlyAffectedHierarchies() {
        return this.partlyHierarchies;
    }

    public Set<DesignComponent> getDescriptorChangedComponents() {
        return this.descriptorChangedComponents;
    }

    public Set<DesignComponent> getCreatedComponents() {
        return this.createdComponents;
    }

    public PropertyValue getOldPropertyValue(DesignComponent component, String propertyName) {
        HashMap<String, PropertyValue> properties = this.oldPropertyValues.get(component);
        if (properties == null) {
            return null;
        }
        return properties.get(propertyName);
    }

    public boolean isComponentPropertyChanged(DesignComponent component, String propertyName) {
        HashMap<String, PropertyValue> properties = this.oldPropertyValues.get(component);
        return properties != null && properties.containsKey(propertyName);
    }

    public boolean isSelectionChanged() {
        return this.selectionChanged;
    }

    public boolean isStructureChanged() {
        return this.structureChanged;
    }
}

