/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class MIDPTargetChooserPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    public static final String MIDLET_NAME = "MidletName";
    public static final String MIDLET_CLASSNAME = "MidletClassName";
    public static final String MIDLET_ICON = "MidletIcon";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MIDPTargetChooserPanelGUI gui;
    private TemplateWizard templateWizard = null;

    MIDPTargetChooserPanel() {
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new MIDPTargetChooserPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(MIDPTargetChooserPanel.class);
    }

    public boolean isValid() {
        String message = null;
        if (this.gui == null) {
            message = "ERR_File_NoGUI";
        } else if (this.gui.getTargetName() == null || "".equals(this.gui.getTargetName())) {
            message = "ERR_File_NoTargetName";
        } else if (this.gui.getCreatedFile() != null && new File(this.gui.getCreatedFile()).exists()) {
            message = "ERR_File_AlreadyExists";
        } else if (!Utilities.isJavaIdentifier((String)this.gui.getClassName())) {
            message = "ERR_File_InvalidClassName";
        } else if (!MIDPTargetChooserPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
            message = "ERR_File_InvalidPackageName";
        }
        if (this.templateWizard != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", message != null ? NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)message) : null);
        }
        return message == null;
    }

    private static boolean isValidJavaFolderName(String packageFileName) {
        if (packageFileName == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(packageFileName, "/");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if (Utilities.isJavaIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener lit : this.listeners) {
            lit.stateChanged(e);
        }
    }

    public void readSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        if (this.getComponent() != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), preselectedTarget);
        }
    }

    public void storeSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        if (this.isValid()) {
            String packageFileName;
            FileObject rootFolder = this.gui.getRootFolder();
            FileObject folder = rootFolder.getFileObject(packageFileName = this.gui.getPackageFileName());
            if (folder == null) {
                try {
                    folder = FileUtil.createFolder((FileObject)rootFolder, (String)packageFileName);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    return;
                }
            }
            Templates.setTargetFolder((WizardDescriptor)this.templateWizard, (FileObject)folder);
            Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetName());
            if (this.gui.isMIDletTemplate()) {
                this.templateWizard.putProperty(MIDLET_NAME, (Object)this.gui.getMIDletName());
                this.templateWizard.putProperty(MIDLET_ICON, (Object)this.gui.getMIDletIcon());
                ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
                String fullTarget = null;
                if (cp != null) {
                    fullTarget = cp.getResourceName(folder, '.', false);
                }
                fullTarget = fullTarget != null && !"".equals(fullTarget) ? fullTarget + "." + this.gui.getClassName() : this.gui.getClassName();
                ((WizardDescriptor)settings).putProperty(MIDLET_CLASSNAME, (Object)fullTarget);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
        }
        this.fireChange();
    }

    public boolean isFinishPanel() {
        return true;
    }
}

