# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.component import Component

class Controller(Component):
    """
    Responsible for putting together a user interface and data. In a typical
    scenario the user interface is made of widgets from a specific toolkit
    and data is retrieved from L{elisa.core.resource_manager.ResourceManager}
    in the form of L{elisa.core.components.model.Model}s.
    L{Controller}s are created by L{elisa.core.components.frontend.Frontend}s.
    Often, a notion of compatibility between controllers and frontends will
    exist.

    Example:

    A GTK based frontend will create a window and GTK specific controllers
    that in turn will create GTK widgets. The controllers will fill the
    widgets with the data of their choice.
    """
    pass
