/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.ResultExternal;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private Session session;
    private TableData table;
    private SortOrder sort;
    private Index index;
    private Cursor cursor;

    public ResultTempTable(Session session, SortOrder sortOrder) throws SQLException {
        this.session = session;
        this.sort = sortOrder;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        Column column = new Column(COLUMN_NAME, 17);
        column.setNullable(false);
        ObjectArray objectArray = new ObjectArray();
        objectArray.add(column);
        int n = session.getDatabase().allocateObjectId(true, true);
        String string = "TEMP_RESULT_SET_" + n;
        this.table = schema.createTable(string, n, objectArray, false, false, -1);
        int n2 = session.getDatabase().allocateObjectId(true, false);
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.column = column;
        indexColumn.columnName = COLUMN_NAME;
        IndexType indexType = IndexType.createPrimaryKey(true, false);
        IndexColumn[] indexColumnArray = new IndexColumn[]{indexColumn};
        this.index = new BtreeIndex(session, this.table, n2, string, indexColumnArray, indexType, -1);
        this.table.getIndexes().add(this.index);
    }

    public int removeRow(Value[] valueArray) throws SQLException {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    public boolean contains(Value[] valueArray) throws SQLException {
        return this.find(this.convertToRow(valueArray)) != null;
    }

    public int addRow(Value[] valueArray) throws SQLException {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor == null) {
            this.table.addRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    public void addRows(ObjectArray objectArray) throws SQLException {
        if (this.sort != null) {
            this.sort.sort(objectArray);
        }
        for (int i = 0; i < objectArray.size(); ++i) {
            Value[] valueArray = (Value[])objectArray.get(i);
            this.addRow(valueArray);
        }
    }

    public void close() {
        try {
            if (this.table != null) {
                this.index.remove(this.session);
                ObjectArray objectArray = this.table.getIndexes();
                objectArray.remove(objectArray.indexOf(this.index));
                this.table.removeChildrenAndResources(this.session);
            }
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
        finally {
            this.table = null;
        }
    }

    public void done() {
    }

    public Value[] next() throws SQLException {
        if (!this.cursor.next()) {
            return null;
        }
        Row row = this.cursor.get();
        ValueArray valueArray = (ValueArray)row.getValue(0);
        return valueArray.getList();
    }

    public void reset() throws SQLException {
        this.cursor = this.index.find(this.session, null, null);
    }

    private Row convertToRow(Value[] valueArray) {
        ValueArray valueArray2 = ValueArray.get(valueArray);
        return new Row(new Value[]{valueArray2}, valueArray2.getMemory());
    }

    private Cursor find(Row row) throws SQLException {
        Cursor cursor = this.index.find(this.session, row, row);
        while (cursor.next()) {
            SearchRow searchRow = cursor.getSearchRow();
            if (!searchRow.getValue(0).equals(row.getValue(0))) continue;
            return cursor;
        }
        return null;
    }
}

