/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.jaffl.LastError;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.BaseHeapFileStat;
import org.jruby.ext.posix.DefaultNativeGroup;
import org.jruby.ext.posix.DefaultNativeTimeval;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.Timeval;

abstract class BaseNativePOSIX
implements POSIX {
    private final LibC libc;
    protected final String libraryName;
    protected final POSIXHandler handler;
    protected final JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new DefaultNativeGroup((Pointer)arg2) : null;
        }
    };
    public static final ToNativeConverter<FileStat, Struct> FileStatConverter = new ToNativeConverter<FileStat, Struct>(){

        @Override
        public Struct toNative(FileStat value2, ToNativeContext context) {
            if (!(value2 instanceof Struct)) {
                throw new IllegalArgumentException("FileStat instance is not a struct");
            }
            return (Struct)((Object)value2);
        }

        @Override
        public Class<Struct> nativeType() {
            return Struct.class;
        }
    };

    BaseNativePOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        this.handler = handler;
        this.libraryName = libraryName;
        this.libc = libcProvider.getLibC();
        this.helper = new JavaLibCHelper(handler);
    }

    public final LibC libc() {
        return this.libc;
    }

    public int chmod(String filename2, int mode2) {
        return this.libc().chmod(filename2, mode2);
    }

    public int chown(String filename2, int user, int group2) {
        return this.libc().chown(filename2, user, group2);
    }

    public int exec(String path2, String ... args2) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    public int exec(String path2, String[] args2, String[] envp) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    public int execv(String path2, String[] args2) {
        return this.libc().execv(path2, args2);
    }

    public int execve(String path2, String[] args2, String[] env) {
        return this.libc().execve(path2, args2, env);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat2 = this.allocateStat();
        if (this.fstat(fileDescriptor, stat2) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "" + this.helper.getfd(fileDescriptor));
        }
        return stat2;
    }

    public int fstat(FileDescriptor fileDescriptor, FileStat stat2) {
        int fd = this.helper.getfd(fileDescriptor);
        return this.libc().fstat(fd, stat2);
    }

    public String getenv(String envName) {
        return this.libc().getenv(envName);
    }

    public int getegid() {
        return this.libc().getegid();
    }

    public int geteuid() {
        return this.libc().geteuid();
    }

    public int getgid() {
        return this.libc().getgid();
    }

    public String getlogin() {
        return this.libc().getlogin();
    }

    public int getpgid() {
        return this.libc().getpgid();
    }

    public int getpgrp() {
        return this.libc().getpgrp();
    }

    public int getpid() {
        return this.libc().getpid();
    }

    public int getppid() {
        return this.libc().getppid();
    }

    public Passwd getpwent() {
        return this.libc().getpwent();
    }

    public Passwd getpwuid(int which) {
        return this.libc().getpwuid(which);
    }

    public Passwd getpwnam(String which) {
        return this.libc().getpwnam(which);
    }

    public Group getgrent() {
        return this.libc().getgrent();
    }

    public Group getgrgid(int which) {
        return this.libc().getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.libc().getgrnam(which);
    }

    public int setpwent() {
        return this.libc().setpwent();
    }

    public int endpwent() {
        return this.libc().endpwent();
    }

    public int setgrent() {
        return this.libc().setgrent();
    }

    public int endgrent() {
        return this.libc().endgrent();
    }

    public int getuid() {
        return this.libc().getuid();
    }

    public int setegid(int egid2) {
        return this.libc().setegid(egid2);
    }

    public int seteuid(int euid2) {
        return this.libc().seteuid(euid2);
    }

    public int setgid(int gid2) {
        return this.libc().setgid(gid2);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    public int getpgid(int pid2) {
        return this.libc().getpgid(pid2);
    }

    public int setpgid(int pid2, int pgid) {
        return this.libc().setpgid(pid2, pgid);
    }

    public int setpgrp(int pid2, int pgrp) {
        return this.libc().setpgrp(pid2, pgrp);
    }

    public int setsid() {
        return this.libc().setsid();
    }

    public int setuid(int uid2) {
        return this.libc().setuid(uid2);
    }

    public int kill(int pid2, int signal2) {
        return this.libc().kill(pid2, signal2);
    }

    public int lchmod(String filename2, int mode2) {
        return this.libc().lchmod(filename2, mode2);
    }

    public int lchown(String filename2, int user, int group2) {
        return this.libc().lchown(filename2, user, group2);
    }

    public int link(String oldpath, String newpath) {
        return this.libc().link(oldpath, newpath);
    }

    public FileStat lstat(String path2) {
        BaseHeapFileStat stat2 = this.allocateStat();
        if (this.lstat(path2, stat2) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), path2);
        }
        return stat2;
    }

    public int lstat(String path2, FileStat stat2) {
        return this.libc().lstat(path2, stat2);
    }

    public int mkdir(String path2, int mode2) {
        int res = this.libc().mkdir(path2, mode2);
        if (res < 0) {
            int errno2 = this.errno();
            this.handler.error(Errno.valueOf(errno2), path2);
        }
        return res;
    }

    public int setenv(String envName, String envValue, int overwrite) {
        return this.libc().setenv(envName, envValue, overwrite);
    }

    public FileStat stat(String path2) {
        BaseHeapFileStat stat2 = this.allocateStat();
        if (this.stat(path2, stat2) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), path2);
        }
        return stat2;
    }

    public int stat(String path2, FileStat stat2) {
        return this.libc().stat(path2, stat2);
    }

    public int symlink(String oldpath, String newpath) {
        return this.libc().symlink(oldpath, newpath);
    }

    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result2 = this.libc().readlink(oldpath, buffer, buffer.capacity());
        if (result2 == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result2);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int unsetenv(String envName) {
        return this.libc().unsetenv(envName);
    }

    public int umask(int mask) {
        return this.libc().umask(mask);
    }

    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        Timeval[] times2 = null;
        if (atimeval != null && mtimeval != null) {
            times2 = (Timeval[])StructUtil.newArray(DefaultNativeTimeval.class, (int)2);
            times2[0].setTime(atimeval);
            times2[1].setTime(mtimeval);
        }
        return this.libc().utimes(path2, times2);
    }

    public int fork() {
        return this.libc().fork();
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        return this.libc().waitpid(pid2, status2, flags);
    }

    public int wait(int[] status2) {
        return this.libc().wait(status2);
    }

    public int getpriority(int which, int who) {
        return this.libc().getpriority(which, who);
    }

    public int setpriority(int which, int who, int prio) {
        return this.libc().setpriority(which, who, prio);
    }

    public boolean isatty(FileDescriptor fd) {
        return this.libc().isatty(this.helper.getfd(fd)) != 0;
    }

    public int errno() {
        return LastError.getLastError();
    }

    public void errno(int value2) {
        LastError.setLastError(value2);
    }

    public boolean isNative() {
        return true;
    }

    public abstract BaseHeapFileStat allocateStat();

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

