/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.util.ConvertBytes;
import org.jruby.util.IdUtil;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;
    private static EvalBinding evalBinding18 = new EvalBinding(){

        public Binding convertToBinding(IRubyObject scope) {
            if (scope instanceof RubyBinding) {
                return ((RubyBinding)scope).getBinding().clone();
            }
            if (scope instanceof RubyProc) {
                return ((RubyProc)scope).getBlock().getBinding().clone();
            }
            throw scope.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
        }
    };
    private static EvalBinding evalBinding19 = new EvalBinding(){

        public Binding convertToBinding(IRubyObject scope) {
            if (scope instanceof RubyBinding) {
                return ((RubyBinding)scope).getBinding().clone();
            }
            throw scope.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Binding)");
        }
    };
    private static final Uncaught uncaught18 = new Uncaught(){

        public RaiseException uncaughtThrow(Ruby runtime2, String message2, IRubyObject tag2) {
            return runtime2.newNameError(message2, tag2.toString());
        }
    };
    private static final Uncaught uncaught19 = new Uncaught(){

        public RaiseException uncaughtThrow(Ruby runtime2, String message2, IRubyObject tag2) {
            return runtime2.newArgumentError(message2);
        }
    };

    public static RubyModule createKernelModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Kernel");
        runtime2.setKernel(module);
        module.defineAnnotatedMethods(RubyKernel.class);
        runtime2.setRespondToMethod(module.searchMethod("respond_to?"));
        module.setFlag(4096, false);
        runtime2.setPrivateMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PRIVATE, CallType.NORMAL, args2, block);
            }
        });
        runtime2.setProtectedMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PROTECTED, CallType.NORMAL, args2, block);
            }
        });
        runtime2.setVariableMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.VARIABLE, args2, block);
            }
        });
        runtime2.setSuperMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.SUPER, args2, block);
            }
        });
        runtime2.setNormalMethodMissing(new MethodMissingMethod(module){

            public IRubyObject methodMissing(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return RubyKernel.methodMissing(context, self, name2, Visibility.PUBLIC, CallType.NORMAL, args2, block);
            }
        });
        if (!runtime2.is1_9()) {
            runtime2.setDefaultMethodMissing(module.searchMethod("method_missing"));
        }
        return module;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().pushExitBlock(context.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        String name2;
        Ruby runtime2 = context.getRuntime();
        RubyModule module = RubyKernel.getModuleForAutoload(runtime2, recv2);
        String file2 = module.getAutoloadFile(name2 = symbol.asJavaString());
        return file2 == null ? runtime2.getNil() : runtime2.newString(file2);
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject recv2, IRubyObject symbol, final IRubyObject file2) {
        Ruby runtime2 = recv2.getRuntime();
        String nonInternedName = symbol.asJavaString();
        if (!IdUtil.isValidConstantName(nonInternedName)) {
            throw runtime2.newNameError("autoload must be constant name", nonInternedName);
        }
        if (!runtime2.is1_9() && !(file2 instanceof RubyString)) {
            throw runtime2.newTypeError(file2, runtime2.getString());
        }
        RubyString fileString = RubyFile.get_path(runtime2.getCurrentContext(), file2);
        if (fileString.isEmpty()) {
            throw runtime2.newArgumentError("empty file name");
        }
        final String baseName = symbol.asJavaString().intern();
        final RubyModule module = RubyKernel.getModuleForAutoload(runtime2, recv2);
        IRubyObject existingValue = module.fastFetchConstant(baseName);
        if (existingValue != null && existingValue != RubyObject.UNDEF) {
            return runtime2.getNil();
        }
        module.defineAutoload(baseName, new IAutoloadMethod(){

            public String file() {
                return file2.toString();
            }

            public void load(Ruby runtime2) {
                if (runtime2.getLoadService().lockAndRequire(this.file())) {
                    module.finishAutoload(baseName);
                }
            }
        });
        return runtime2.getNil();
    }

    private static RubyModule getModuleForAutoload(Ruby runtime2, IRubyObject recv2) {
        RubyModule module;
        RubyModule rubyModule = module = recv2 instanceof RubyModule ? (RubyModule)recv2 : runtime2.getObject();
        if (module == runtime2.getKernel()) {
            module = runtime2.is1_9() ? runtime2.getObject().getSingletonClass() : runtime2.getObject();
        }
        return module;
    }

    @JRubyMethod(rest=true, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.getRuntime().newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2, block);
    }

    protected static IRubyObject methodMissingDirect(ThreadContext context, IRubyObject recv2, RubySymbol symbol, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        IRubyObject[] exArgs;
        RubyClass exc;
        Ruby runtime2 = context.getRuntime();
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(runtime2, recv2, symbol, lastVis, lastCallType);
        if (lastCallType != CallType.VARIABLE) {
            exc = runtime2.getNoMethodError();
            exArgs = new IRubyObject[]{msg, symbol, RubyArray.newArrayNoCopy(runtime2, args2, 1)};
        } else {
            exc = runtime2.getNameError();
            exArgs = new IRubyObject[]{msg, symbol};
        }
        throw new RaiseException((RubyException)exc.newInstance(context, exArgs, Block.NULL_BLOCK));
    }

    private static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        IRubyObject[] exArgs;
        RubyClass exc;
        Ruby runtime2 = context.getRuntime();
        RubySymbol symbol = runtime2.newSymbol(name2);
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(runtime2, recv2, symbol, lastVis, lastCallType);
        if (lastCallType != CallType.VARIABLE) {
            exc = runtime2.getNoMethodError();
            exArgs = new IRubyObject[]{msg, symbol, RubyArray.newArrayNoCopy(runtime2, args2)};
        } else {
            exc = runtime2.getNameError();
            exArgs = new IRubyObject[]{msg, symbol};
        }
        throw new RaiseException((RubyException)exc.newInstance(context, exArgs, Block.NULL_BLOCK));
    }

    @JRubyMethod(required=1, optional=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String arg2 = args2[0].convertToString().toString();
        Ruby runtime2 = context.getRuntime();
        if (arg2.startsWith("|")) {
            String command = arg2.substring(1);
            return RubyIO.popen(context, runtime2.getIO(), new IRubyObject[]{runtime2.newString(command)}, block);
        }
        return RubyFile.open(context, runtime2.getFile(), args2, block);
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (args2[0].respondsTo("to_open")) {
            args2[0] = args2[0].callMethod(context, "to_open");
            return RubyFile.open(context, runtime2.getFile(), args2, block);
        }
        return RubyKernel.open(context, recv2, args2, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        context.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead");
        IRubyObject defin = context.getRuntime().getGlobalVariables().get("$stdin");
        return defin.callMethod(context, "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.gets(context, context.getRuntime().getArgsFile(), args2);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 1) {
            runtime2.getGlobalVariables().get("$stderr").callMethod(context, "puts", args2[0].convertToString());
        }
        RubyKernel.exit(runtime2, new IRubyObject[]{runtime2.getFalse()}, false);
        return runtime2.getNil();
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RuntimeHelpers.arrayValue(context, context.getRuntime(), object);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getComplex(), "convert");
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg2);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getRational(), "convert");
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg2);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat new_float(IRubyObject recv2, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return (RubyFloat)object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().getRealSize() == 0) {
                throw recv2.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv2.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv2.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = (RubyFloat)TypeConverter.convertToType(object, recv2.getRuntime().getFloat(), "to_f");
        if (Double.isNaN(rFloat.getDoubleValue())) {
            throw recv2.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rFloat;
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat new_float19(IRubyObject recv2, IRubyObject object) {
        Ruby runtime2 = recv2.getRuntime();
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(runtime2, ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return (RubyFloat)object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(runtime2, RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().getRealSize() == 0) {
                throw runtime2.newArgumentError("invalid value for Float(): " + object.inspect());
            }
            RubyString arg2 = (RubyString)object;
            if (arg2.toString().startsWith("0x")) {
                return ConvertBytes.byteListToInum19(runtime2, arg2.getByteList(), 16, true).toFloat();
            }
            return RubyNumeric.str2fnum19(runtime2, arg2, true);
        }
        if (object.isNil()) {
            throw runtime2.newTypeError("can't convert nil into Float");
        }
        return (RubyFloat)TypeConverter.convertToType19(object, runtime2.getFloat(), "to_f");
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val >= 9.223372036854776E18 || val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(context.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, 0, true);
            }
        }
        if ((tmp = TypeConverter.convertToType(object, context.getRuntime().getInteger(), "to_int", false)).isNil()) {
            return object.convertToInteger("to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val > 9.223372036854776E18 && val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(context.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, 0, true);
            }
            if (object instanceof RubyNil) {
                throw context.getRuntime().newTypeError("can't convert nil into Integer");
            }
        }
        if ((tmp = TypeConverter.convertToType(object, context.getRuntime().getInteger(), "to_int", false)).isNil()) {
            return object.convertToInteger("to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject base) {
        int bs = RubyNumeric.num2int(base);
        if (object instanceof RubyString) {
            return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, bs, true);
        }
        IRubyObject tmp = object.checkStringType();
        if (!tmp.isNil()) {
            return RubyNumeric.str2inum(context.getRuntime(), (RubyString)tmp, bs, true);
        }
        throw context.getRuntime().newArgumentError("base specified for non string value");
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject new_string(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.convertToType(object, context.getRuntime().getString(), "to_s");
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_string19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.convertToType19(object, context.getRuntime().getString(), "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject defout = runtime2.getGlobalVariables().get("$>");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2] == null) continue;
            defout.callMethod(context, "write", RubyObject.inspect(context, args2[i2]));
            defout.callMethod(context, "write", runtime2.newString("\n"));
        }
        IRubyObject result2 = runtime2.getNil();
        if (runtime2.is1_9()) {
            if (args2.length == 1) {
                result2 = args2[0];
            } else if (args2.length > 1) {
                result2 = runtime2.newArray(args2);
            }
        }
        if (defout instanceof RubyFile) {
            ((RubyFile)defout).flush();
        }
        return result2;
    }

    @JRubyMethod(name={"public_method"}, required=1, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject public_method(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return recv2.getMetaClass().newMethod(recv2, symbol.asJavaString(), true, Visibility.PUBLIC, true, false);
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext context, IRubyObject recv2, IRubyObject ch) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.putc(context, defout, ch);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.puts(context, defout, args2);
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return RubyIO.print(context, defout, args2);
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length != 0) {
            IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
            if (!(args2[0] instanceof RubyString)) {
                defout = args2[0];
                args2 = ArgsUtil.popArray(args2);
            }
            defout.callMethod(context, "write", RubyKernel.sprintf(context, recv2, args2));
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyKernel.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.readlines(context, context.getRuntime().getArgsFile(), args2);
    }

    @JRubyMethod(name={"respond_to_missing?"}, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"respond_to_missing?"}, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol, IRubyObject isPrivate) {
        return context.getRuntime().getFalse();
    }

    private static RubyString getLastlineString(ThreadContext context, Ruby runtime2) {
        IRubyObject line = context.getCurrentScope().getLastLine(runtime2);
        if (line.isNil()) {
            throw runtime2.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime2.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, args2, block);
    }

    @JRubyMethod(name={"sub!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"sub!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, args2, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, arg1, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, args2, block);
    }

    @JRubyMethod(name={"gsub!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"gsub!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, args2, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, arg1, block).isNil()) {
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"chop!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chop_bang(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chop_bang(context);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chop(ThreadContext context, IRubyObject recv2, Block block) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        if (str.getByteList().getRealSize() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang(context);
            context.getCurrentScope().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(args2);
    }

    @JRubyMethod(name={"chomp!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(context);
    }

    @JRubyMethod(name={"chomp!"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(context, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv2) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup2 = (RubyString)str.dup();
        if (dup2.chomp_bang(context).isNil()) {
            return str;
        }
        context.getCurrentScope().setLastLine(dup2);
        return dup2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup2 = (RubyString)str.dup();
        if (dup2.chomp_bang(context, arg0).isNil()) {
            return str;
        }
        context.getCurrentScope().setLastLine(dup2);
        return dup2;
    }

    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, args2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject split(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0, arg1);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.LASTLINE, FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject scan(ThreadContext context, IRubyObject recv2, IRubyObject pattern, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).scan(context, pattern, block);
    }

    @JRubyMethod(required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.getRuntime(), args2);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long loopStartTime;
        long milliseconds;
        if (args2.length == 0) {
            milliseconds = 0L;
        } else {
            if (!(args2[0] instanceof RubyNumeric)) {
                throw context.getRuntime().newTypeError("can't convert " + args2[0].getMetaClass().getName() + "into time interval");
            }
            milliseconds = (long)(args2[0].convertToFloat().getDoubleValue() * 1000.0);
            if (milliseconds < 0L) {
                throw context.getRuntime().newArgumentError("time interval must be positive");
            }
            if (milliseconds == 0L) {
                return context.getRuntime().newFixnum(0);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = context.getThread();
        do {
            loopStartTime = System.currentTimeMillis();
            try {
                if (rubyThread.sleep(milliseconds)) continue;
                break;
            }
            catch (InterruptedException iExcptn) {
                // empty catch block
            }
        } while ((milliseconds -= System.currentTimeMillis() - loopStartTime) > 0L);
        return context.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, false);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, true);
        return recv2.getRuntime().getNil();
    }

    private static void exit(Ruby runtime2, IRubyObject[] args2, boolean hard) {
        int status2;
        runtime2.secure(4);
        int n = status2 = hard ? 1 : 0;
        if (args2.length > 0) {
            RubyObject argument = (RubyObject)args2[0];
            status2 = argument instanceof RubyBoolean ? (argument.isFalse() ? 1 : 0) : RubyNumeric.fix2int(argument);
        }
        if (hard) {
            if (!runtime2.getInstanceConfig().isHardExit()) {
                throw new MainExitException(status2, true);
            }
        } else {
            throw runtime2.newSystemExit(status2);
        }
        System.exit(status2);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray globalVariables = runtime2.newArray();
        for (String globalVariableName : runtime2.getGlobalVariables().getNames()) {
            globalVariables.append(runtime2.newString(globalVariableName));
        }
        return globalVariables;
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyArray global_variables19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray globalVariables = runtime2.newArray();
        for (String globalVariableName : runtime2.getGlobalVariables().getNames()) {
            globalVariables.append(runtime2.newSymbol(globalVariableName));
        }
        return globalVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray localVariables = runtime2.newArray();
        for (String name2 : context.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(name2)) continue;
            localVariables.append(runtime2.newString(name2));
        }
        return localVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyArray local_variables19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray localVariables = runtime2.newArray();
        for (String name2 : context.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(name2)) continue;
            localVariables.append(runtime2.newSymbol(name2));
        }
        return localVariables;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static RubyBinding binding(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.getRuntime(), context.currentBinding(recv2));
    }

    @JRubyMethod(name={"binding"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyBinding binding19(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.getRuntime(), context.currentBinding());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(context.getCurrentFrame().getBlock().isGiven());
    }

    @Deprecated
    public static IRubyObject sprintf(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.sprintf(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2;
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args2[0]);
        if (context.runtime.is1_9() && args2.length == 2 && args2[1] instanceof RubyHash) {
            arg2 = args2[1];
        } else {
            RubyArray newArgs = context.getRuntime().newArrayNoCopy(args2);
            newArgs.shift(context);
            arg2 = newArgs;
        }
        return str.op_format(context, arg2);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject raise(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RaiseException raise2;
        Ruby runtime2 = context.getRuntime();
        switch (args2.length) {
            case 0: {
                IRubyObject lastException = runtime2.getGlobalVariables().get("$!");
                if (lastException.isNil()) {
                    raise2 = new RaiseException(runtime2, runtime2.getRuntimeError(), "", false);
                    break;
                }
                raise2 = new RaiseException((RubyException)lastException);
                break;
            }
            case 1: {
                if (args2[0] instanceof RubyString) {
                    raise2 = new RaiseException((RubyException)runtime2.getRuntimeError().newInstance(context, args2, block));
                    break;
                }
                raise2 = new RaiseException(RubyKernel.convertToException(runtime2, args2[0], null));
                break;
            }
            case 2: {
                raise2 = new RaiseException(RubyKernel.convertToException(runtime2, args2[0], args2[1]));
                break;
            }
            default: {
                raise2 = new RaiseException(RubyKernel.convertToException(runtime2, args2[0], args2[1]), args2[2]);
            }
        }
        if (runtime2.getDebug().isTrue()) {
            RubyKernel.printExceptionSummary(context, runtime2, raise2.getException());
        }
        throw raise2;
    }

    private static RubyException convertToException(Ruby runtime2, IRubyObject obj, IRubyObject optionalMessage) {
        if (!obj.respondsTo("exception")) {
            throw runtime2.newTypeError("exception class/object expected");
        }
        IRubyObject exception2 = optionalMessage == null ? obj.callMethod(runtime2.getCurrentContext(), "exception") : obj.callMethod(runtime2.getCurrentContext(), "exception", optionalMessage);
        try {
            return (RubyException)exception2;
        }
        catch (ClassCastException cce) {
            throw runtime2.newTypeError("exception object expected");
        }
    }

    private static void printExceptionSummary(ThreadContext context, Ruby runtime2, RubyException rEx) {
        RubyStackTraceElement[] elements = rEx.getBacktraceElements();
        RubyStackTraceElement firstElement = elements[0];
        String msg = String.format("Exception `%s' at %s:%s - %s\n", rEx.getMetaClass(), firstElement.getFileName(), firstElement.getLineNumber(), runtime2.is1_9() ? TypeConverter.convertToType(rEx, runtime2.getString(), "to_s") : rEx.convertToString().toString());
        runtime2.getErrorStream().print(msg);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject require(IRubyObject recv2, IRubyObject name2, Block block) {
        return RubyKernel.requireCommon(recv2.getRuntime(), recv2, name2, block);
    }

    @JRubyMethod(name={"require"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject require19(ThreadContext context, IRubyObject recv2, IRubyObject name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject tmp = name2.checkStringType();
        if (!tmp.isNil()) {
            return RubyKernel.requireCommon(runtime2, recv2, tmp, block);
        }
        return RubyKernel.requireCommon(runtime2, recv2, name2.respondsTo("to_path") ? name2.callMethod(context, "to_path") : name2, block);
    }

    private static IRubyObject requireCommon(Ruby runtime2, IRubyObject recv2, IRubyObject name2, Block block) {
        if (runtime2.getLoadService().lockAndRequire(name2.convertToString().toString())) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject load(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.loadCommon(args2[0], recv2.getRuntime(), args2, block);
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject load19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject file2 = args2[0];
        if (!(file2 instanceof RubyString) && file2.respondsTo("to_path")) {
            file2 = file2.callMethod(context, "to_path");
        }
        return RubyKernel.loadCommon(file2, context.getRuntime(), args2, block);
    }

    private static IRubyObject loadCommon(IRubyObject fileName, Ruby runtime2, IRubyObject[] args2, Block block) {
        RubyString file2 = fileName.convertToString();
        boolean wrap2 = args2.length == 2 ? args2[1].isTrue() : false;
        runtime2.getLoadService().load(file2.toString(), wrap2);
        return runtime2.getTrue();
    }

    @JRubyMethod(required=1, optional=3, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject eval(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.evalCommon(context, recv2, args2, block, evalBinding18);
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject eval19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.evalCommon(context, recv2, args2, block, evalBinding19);
    }

    private static IRubyObject evalCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block, EvalBinding evalBinding) {
        Binding binding2;
        Ruby runtime2 = context.getRuntime();
        RubyString src = args2[0].convertToString();
        runtime2.checkSafeString(src);
        boolean bindingGiven = args2.length > 1 && !args2[1].isNil();
        Binding binding3 = binding2 = bindingGiven ? evalBinding.convertToBinding(args2[1]) : context.currentBinding();
        if (args2.length > 2) {
            binding2.setFile(args2[2].convertToString().toString());
            if (args2.length > 3) {
                binding2.setLine((int)args2[3].convertToInteger().getLongValue() - 1);
            } else {
                binding2.setLine(0);
            }
        } else if (!bindingGiven) {
            binding2.setFile("(eval)");
            binding2.setLine(0);
        }
        String frameName = context.getFrameName();
        if (frameName != null) {
            binding2.setMethod(frameName);
        }
        if (bindingGiven) {
            recv2 = binding2.getSelf();
        }
        return ASTInterpreter.evalWithBinding(context, recv2, src, binding2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(ThreadContext context, IRubyObject recv2, Block block) {
        RubyContinuation continuation = new RubyContinuation(context.getRuntime());
        return continuation.enter(context, continuation, block);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int level2;
        int n = level2 = args2.length > 0 ? RubyNumeric.fix2int(args2[0]) : 1;
        if (level2 < 0) {
            throw context.getRuntime().newArgumentError("negative level (" + level2 + ')');
        }
        return context.createCallerBacktrace(context.getRuntime(), level2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        Ruby runtime2 = context.runtime;
        RubySymbol sym = RubyKernel.stringOrSymbol(tag2);
        RubyContinuation rbContinuation = new RubyContinuation(runtime2, sym);
        try {
            context.pushCatch(rbContinuation.getContinuation());
            IRubyObject iRubyObject = rbContinuation.enter(context, sym, block);
            Object var9_8 = null;
            context.popCatch();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            context.popCatch();
            throw throwable;
        }
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rbCatch19(ThreadContext context, IRubyObject recv2, Block block) {
        RubyObject tag2 = new RubyObject(context.runtime.getObject());
        return RubyKernel.rbCatch19Common(context, tag2, block);
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rbCatch19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbCatch19Common(context, tag2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject rbCatch19Common(ThreadContext context, IRubyObject tag2, Block block) {
        RubyContinuation rbContinuation = new RubyContinuation(context.getRuntime(), tag2);
        try {
            context.pushCatch(rbContinuation.getContinuation());
            IRubyObject iRubyObject = rbContinuation.enter(context, tag2, block);
            Object var6_5 = null;
            context.popCatch();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.popCatch();
            throw throwable;
        }
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbThrowInternal(context, RubyKernel.stringOrSymbol(tag2), IRubyObject.NULL_ARRAY, block, uncaught18);
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, IRubyObject arg2, Block block) {
        return RubyKernel.rbThrowInternal(context, RubyKernel.stringOrSymbol(tag2), new IRubyObject[]{arg2}, block, uncaught18);
    }

    private static RubySymbol stringOrSymbol(IRubyObject obj) {
        if (obj instanceof RubySymbol) {
            return (RubySymbol)obj;
        }
        return RubySymbol.newSymbol(obj.getRuntime(), obj.asJavaString().intern());
    }

    @JRubyMethod(name={"throw"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rbThrow19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, IRubyObject.NULL_ARRAY, block, uncaught19);
    }

    @JRubyMethod(name={"throw"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rbThrow19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, IRubyObject arg2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, new IRubyObject[]{arg2}, block, uncaught19);
    }

    private static IRubyObject rbThrowInternal(ThreadContext context, IRubyObject tag2, IRubyObject[] args2, Block block, Uncaught uncaught) {
        Ruby runtime2 = context.getRuntime();
        RubyContinuation.Continuation continuation = context.getActiveCatch(tag2);
        if (continuation != null) {
            continuation.args = args2;
            throw continuation;
        }
        String message2 = "uncaught throw `" + tag2 + "'";
        RubyThread currentThread = context.getThread();
        if (currentThread == runtime2.getThreadService().getMainThread()) {
            throw uncaught.uncaughtThrow(runtime2, message2, tag2);
        }
        message2 = message2 + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(currentThread.id()));
        if (runtime2.is1_9()) {
            throw runtime2.newArgumentError(message2);
        }
        throw runtime2.newThreadError(message2);
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        context.getRuntime().getLoadService().require("jsignal_internal");
        return RuntimeHelpers.invoke(context, recv2, "__jtrap", args2, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.warningsEnabled()) {
            IRubyObject out = runtime2.getGlobalVariables().get("$stderr");
            RuntimeHelpers.invoke(context, out, "write", message2);
            RuntimeHelpers.invoke(context, out, "write", runtime2.getGlobalVariables().getDefaultSeparator());
        }
        return runtime2.getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext context, IRubyObject recv2, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            context.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw context.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            context.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyProc proc2 = null;
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args2.length == 1) {
            proc2 = RubyProc.newProc(context.getRuntime(), block, Block.Type.PROC);
        }
        if (args2.length == 2) {
            proc2 = (RubyProc)TypeConverter.convertToType(args2[1], context.getRuntime().getProc(), "to_proc", true);
        }
        context.getRuntime().getGlobalVariables().setTraceVar(var, proc2);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args2.length > 1) {
            ArrayList<IRubyObject> success2 = new ArrayList<IRubyObject>();
            for (int i2 = 1; i2 < args2.length; ++i2) {
                if (!context.getRuntime().getGlobalVariables().untraceVar(var, args2[i2])) continue;
                success2.add(args2[i2]);
            }
            return RubyArray.newArray(context.getRuntime(), success2);
        }
        context.getRuntime().getGlobalVariables().untraceVar(var);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject singleton_method_removed(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject singleton_method_undefined(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject define_singleton_method(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        RubyClass singleton_class2 = recv2.getSingletonClass();
        if (args2.length > 1) {
            RubyUnboundMethod method2;
            RubyModule owner2;
            IRubyObject arg1 = args2[1];
            if (context.runtime.getUnboundMethod().isInstance(args2[1]) && (owner2 = (RubyModule)(method2 = (RubyUnboundMethod)arg1).owner(context)).isSingleton() && (!recv2.getMetaClass().isSingleton() || !recv2.getMetaClass().isKindOfModule(owner2))) {
                throw context.runtime.newTypeError("can't bind singleton method to a different class");
            }
            return singleton_class2.define_method(context, args2[0], args2[1], block);
        }
        return singleton_class2.define_method(context, args2[0], block);
    }

    @JRubyMethod(name={"proc", "lambda"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        return context.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext context, IRubyObject recv2, Block block) {
        if (context.runtime.is1_9() && !block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "loop");
        }
        IRubyObject nil = context.getRuntime().getNil();
        RubyClass stopIteration = context.getRuntime().getStopIteration();
        try {
            while (true) {
                block.yieldSpecific(context);
                context.pollThreadEvents();
            }
        }
        catch (RaiseException ex) {
            if (!stopIteration.op_eqq(context, ex.getException()).isTrue()) {
                throw ex;
            }
            return nil;
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError("wrong number of arguments");
        }
        int cmd = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubyString && ((RubyString)args2[0]).getByteList().length() > 0 ? (int)((RubyString)args2[0]).getByteList().charAt(0) : (int)args2[0].convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw context.getRuntime().newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args2.length == 3) break;
                throw context.getRuntime().newArgumentError(args2.length, 3);
            }
            default: {
                if (args2.length == 2) break;
                throw context.getRuntime().newArgumentError(args2.length, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(recv2, args2[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(recv2, args2[1]);
            }
            case 67: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(recv2, args2[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(recv2, args2[1]);
            }
            case 102: {
                return RubyFileTest.file_p(recv2, args2[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(recv2, args2[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(recv2, args2[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(recv2, args2[1]);
            }
            case 77: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(recv2, args2[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(recv2, args2[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(recv2, args2[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(recv2, args2[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 115: {
                return RubyFileTest.size_p(recv2, args2[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(recv2, args2[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(recv2, args2[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(recv2, args2[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(recv2, args2[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(recv2, args2[1]);
            }
            case 61: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeEquals(args2[2]);
            }
            case 60: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeLessThan(args2[2]);
            }
            case 62: {
                return context.getRuntime().newFileStat(args2[1].convertToString().toString(), false).mtimeGreaterThan(args2[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(recv2, args2[1], args2[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext context, IRubyObject recv2, IRubyObject aString) {
        long[] tuple;
        Ruby runtime2 = context.getRuntime();
        RubyString string2 = aString.convertToString();
        IRubyObject[] args2 = new IRubyObject[]{string2};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            tuple = ShellLauncher.runAndWaitPid(runtime2, args2, output, false);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple[0], tuple[1]));
        byte[] out = output.toByteArray();
        int length2 = out.length;
        if (Platform.IS_WINDOWS) {
            int newPos = 0;
            for (int pos2 = 0; pos2 < length2; ++pos2) {
                byte curr = out[pos2];
                if (pos2 == length2 - 1) {
                    out[newPos++] = curr;
                    break;
                }
                byte next2 = out[pos2 + 1];
                if (curr == 13 && next2 == 10) continue;
                out[newPos++] = curr;
            }
            length2 = newPos;
        }
        return RubyString.newStringNoCopy(runtime2, out, 0, length2);
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyInteger srand(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyInteger oldRandomSeed = runtime2.getRandomSeed();
        long seedArg = runtime2.newRandomSeed();
        runtime2.setRandomSeed(RubyBignum.newBignum(runtime2, seedArg));
        runtime2.getRandom().setSeed(seedArg);
        return oldRandomSeed;
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyInteger srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyInteger newRandomSeed = arg2.convertToInteger("to_int");
        Ruby runtime2 = context.getRuntime();
        RubyInteger oldRandomSeed = runtime2.getRandomSeed();
        long seedArg = 0L;
        if (newRandomSeed instanceof RubyBignum) {
            seedArg = ((RubyBignum)newRandomSeed).getValue().longValue();
        } else if (!arg2.isNil()) {
            seedArg = RubyNumeric.num2long(newRandomSeed);
        }
        runtime2.setRandomSeed(newRandomSeed);
        runtime2.getRandom().setSeed(seedArg);
        return oldRandomSeed;
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand19(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srand(context, recv2);
    }

    @JRubyMethod(name={"srand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.srandCommon(context, recv2, arg2.convertToInteger("to_int"), true);
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyNumeric rand(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        return RubyFloat.newFloat(runtime2, runtime2.getRandom().nextDouble());
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyNumeric rand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        Random random = runtime2.getRandom();
        return RubyKernel.randCommon(context, runtime2, random, recv2, arg2);
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyNumeric rand19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        return RubyFloat.newFloat(runtime2, runtime2.getRandom().nextDouble());
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyNumeric rand19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        return RubyKernel.randCommon(context, runtime2, runtime2.getRandom(), recv2, arg2);
    }

    private static RubyNumeric randCommon(ThreadContext context, Ruby runtime2, Random random, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 instanceof RubyBignum) {
            byte[] bigCeilBytes = ((RubyBignum)arg2).getValue().toByteArray();
            BigInteger bigCeil = new BigInteger(bigCeilBytes).abs();
            byte[] randBytes = new byte[bigCeilBytes.length];
            random.nextBytes(randBytes);
            BigInteger result2 = new BigInteger(randBytes).abs().mod(bigCeil);
            return new RubyBignum(runtime2, result2);
        }
        RubyInteger integerCeil = (RubyInteger)RubyKernel.new_integer(context, recv2, arg2);
        long ceil2 = Math.abs(integerCeil.getLongValue());
        if (ceil2 == 0L) {
            return RubyFloat.newFloat(runtime2, random.nextDouble());
        }
        if (ceil2 > Integer.MAX_VALUE) {
            return runtime2.newFixnum(Math.abs(random.nextLong()) % ceil2);
        }
        return runtime2.newFixnum(random.nextInt((int)ceil2));
    }

    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        long pid2 = ShellLauncher.runExternalWithoutWait(runtime2, args2);
        return RubyFixnum.newFixnum(runtime2, pid2);
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyBoolean system(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        return RubyKernel.systemCommon(context, recv2, args2) == 0 ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject system19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int resultCode = RubyKernel.systemCommon(context, recv2, args2);
        switch (resultCode) {
            case 0: {
                return runtime2.getTrue();
            }
            case 127: {
                return runtime2.getNil();
            }
        }
        return runtime2.getFalse();
    }

    private static int systemCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long[] tuple;
        Ruby runtime2 = context.getRuntime();
        try {
            if (!Platform.IS_WINDOWS && args2[args2.length - 1].asJavaString().matches(".*[^&]&\\s*")) {
                ShellLauncher.runWithoutWait(runtime2, args2);
                return 0;
            }
            tuple = ShellLauncher.runAndWaitPid(runtime2, args2);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple[0], tuple[1]));
        return (int)tuple[0];
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, compat=CompatVersion.RUBY1_8, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        return RubyKernel.execCommon(runtime2, null, null, null, args2);
    }

    @JRubyMethod(required=4, module=true, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public static IRubyObject _exec_internal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject env = args2[0];
        IRubyObject prog = args2[1];
        IRubyObject options2 = args2[2];
        RubyArray cmdArgs = (RubyArray)args2[3];
        return RubyKernel.execCommon(runtime2, env, prog, options2, cmdArgs.toJavaArray());
    }

    private static IRubyObject execCommon(Ruby runtime2, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject[] args2) {
        int resultCode;
        RubyHash envMap;
        if (args2.length == 1 && args2[0].convertToString().isEmpty()) {
            throw runtime2.newErrnoENOENTError(args2[0].convertToString().toString());
        }
        ThreadContext context = runtime2.getCurrentContext();
        if (env != null && !env.isNil() && (envMap = env.convertToHash()) != null) {
            runtime2.getENV().merge_bang(context, envMap, Block.NULL_BLOCK);
        }
        if (prog != null && prog.isNil()) {
            prog = null;
        }
        boolean nativeFailed = false;
        try {
            try {
                String[] argv = new String[args2.length];
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    argv[i2] = args2[i2].asJavaString();
                }
                resultCode = runtime2.getPosix().exec(prog == null ? null : prog.asJavaString(), argv);
                nativeFailed = true;
            }
            catch (RaiseException e) {
                resultCode = ShellLauncher.execAndWait(runtime2, args2);
            }
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw runtime2.newErrnoENOENTError("cannot execute");
        }
        if (nativeFailed) {
            throw runtime2.newErrnoENOENTError("cannot execute");
        }
        RubyKernel.exit(runtime2, new IRubyObject[]{runtime2.newFixnum(resultCode)}, true);
        return runtime2.getNil();
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.getRuntime();
        throw runtime2.newNotImplementedError("fork is not available on this platform");
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9, notImplemented=true)
    public static IRubyObject fork19(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.getRuntime();
        throw runtime2.newNotImplementedError("fork is not available on this platform");
    }

    @JRubyMethod(module=true)
    public static IRubyObject tap(ThreadContext context, IRubyObject recv2, Block block) {
        block.yield(context, recv2);
        return recv2;
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_enum(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        switch (args2.length) {
            case 0: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, "each");
            }
            case 1: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString());
            }
            case 2: {
                return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString(), args2[1]);
            }
        }
        IRubyObject[] enumArgs = new IRubyObject[args2.length - 1];
        System.arraycopy(args2, 1, enumArgs, 0, enumArgs.length);
        return RubyEnumerator.enumeratorize(runtime2, recv2, args2[0].asJavaString(), enumArgs);
    }

    @JRubyMethod(name={"__method__", "__callee__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.METHODNAME}, omit=true)
    public static IRubyObject __method__(ThreadContext context, IRubyObject recv2) {
        String frameName = context.getFrameName();
        if (frameName == null) {
            return context.nil;
        }
        return context.runtime.newSymbol(frameName);
    }

    @JRubyMethod(module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return recv2.getSingletonClass();
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject public_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        recv2.getMetaClass().checkMethodBound(context, args2, Visibility.PUBLIC);
        return ((RubyObject)recv2).send19(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject op_equal(ThreadContext context, IRubyObject self, IRubyObject other) {
        return ((RubyBasicObject)self).op_equal(context, other);
    }

    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject equal_p(ThreadContext context, IRubyObject self, IRubyObject other) {
        return ((RubyBasicObject)self).equal_p(context, other);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public static IRubyObject eql_p(IRubyObject self, IRubyObject obj) {
        return ((RubyBasicObject)self).eql_p(obj);
    }

    @JRubyMethod(name={"==="}, required=1)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject self, IRubyObject other) {
        return ((RubyBasicObject)self).op_eqq(context, other);
    }

    @JRubyMethod(name={"<=>"}, required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject op_cmp(ThreadContext context, IRubyObject self, IRubyObject other) {
        return ((RubyBasicObject)self).op_cmp(context, other);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_copy(IRubyObject self, IRubyObject original) {
        return ((RubyBasicObject)self).initialize_copy(original);
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_8)
    public static RubyBoolean respond_to_p(IRubyObject self, IRubyObject mname) {
        return ((RubyBasicObject)self).respond_to_p(mname);
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject respond_to_p19(IRubyObject self, IRubyObject mname) {
        return ((RubyBasicObject)self).respond_to_p19(mname);
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_8)
    public static RubyBoolean respond_to_p(IRubyObject self, IRubyObject mname, IRubyObject includePrivate) {
        return ((RubyBasicObject)self).respond_to_p(mname, includePrivate);
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject respond_to_p19(IRubyObject self, IRubyObject mname, IRubyObject includePrivate) {
        return ((RubyBasicObject)self).respond_to_p19(mname, includePrivate);
    }

    @JRubyMethod(name={"object_id", "__id__"})
    public static IRubyObject id(IRubyObject self) {
        return ((RubyBasicObject)self).id();
    }

    @JRubyMethod(name={"id"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject id_deprecated(IRubyObject self) {
        return ((RubyBasicObject)self).id_deprecated();
    }

    @JRubyMethod(name={"hash"})
    public static RubyFixnum hash(IRubyObject self) {
        return ((RubyBasicObject)self).hash();
    }

    @JRubyMethod(name={"class"})
    public static RubyClass type(IRubyObject self) {
        return ((RubyBasicObject)self).type();
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type_deprecated(IRubyObject self) {
        return ((RubyBasicObject)self).type_deprecated();
    }

    @JRubyMethod(name={"clone"})
    public static IRubyObject rbClone(IRubyObject self) {
        return ((RubyBasicObject)self).rbClone();
    }

    @JRubyMethod
    public static IRubyObject dup(IRubyObject self) {
        return ((RubyBasicObject)self).dup();
    }

    @JRubyMethod(name={"display"}, optional=1)
    public static IRubyObject display(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).display(context, args2);
    }

    @JRubyMethod(name={"tainted?"})
    public static RubyBoolean tainted_p(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).tainted_p(context);
    }

    @JRubyMethod(name={"taint"})
    public static IRubyObject taint(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).taint(context);
    }

    @JRubyMethod(name={"untaint"})
    public static IRubyObject untaint(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).untaint(context);
    }

    @JRubyMethod(name={"freeze"})
    public static IRubyObject freeze(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).freeze(context);
    }

    @JRubyMethod(name={"frozen?"})
    public static RubyBoolean frozen_p(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).frozen_p(context);
    }

    @JRubyMethod(name={"untrusted?"}, compat=CompatVersion.RUBY1_9)
    public static RubyBoolean untrusted_p(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).untrusted_p(context);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject untrust(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).untrust(context);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject trust(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).trust(context);
    }

    @JRubyMethod(name={"inspect"})
    public static IRubyObject inspect(IRubyObject self) {
        return ((RubyBasicObject)self).inspect();
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public static RubyBoolean instance_of_p(ThreadContext context, IRubyObject self, IRubyObject type2) {
        return ((RubyBasicObject)self).instance_of_p(context, type2);
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public static RubyBoolean kind_of_p(ThreadContext context, IRubyObject self, IRubyObject type2) {
        return ((RubyBasicObject)self).kind_of_p(context, type2);
    }

    @JRubyMethod(name={"methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject methods(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).methods(context, args2);
    }

    @JRubyMethod(name={"methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject methods19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).methods19(context, args2);
    }

    @JRubyMethod(name={"public_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject public_methods(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).public_methods(context, args2);
    }

    @JRubyMethod(name={"public_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject public_methods19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).public_methods19(context, args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject protected_methods(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).protected_methods(context, args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject protected_methods19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).protected_methods19(context, args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject private_methods(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).private_methods(context, args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject private_methods19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).private_methods19(context, args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public static RubyArray singleton_methods(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).singleton_methods(context, args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public static RubyArray singleton_methods19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).singleton_methods19(context, args2);
    }

    @JRubyMethod(name={"method"}, required=1)
    public static IRubyObject method(IRubyObject self, IRubyObject symbol) {
        return ((RubyBasicObject)self).method(symbol);
    }

    @JRubyMethod(name={"method"}, required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject method19(IRubyObject self, IRubyObject symbol) {
        return ((RubyBasicObject)self).method19(symbol);
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject self) {
        return ((RubyBasicObject)self).to_s();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC, compat=CompatVersion.RUBY1_8)
    public static RubyArray to_a(IRubyObject self) {
        return ((RubyBasicObject)self).to_a();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject instance_eval(ThreadContext context, IRubyObject self, Block block) {
        return ((RubyBasicObject)self).instance_eval(context, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject instance_eval(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        return ((RubyBasicObject)self).instance_eval(context, arg0, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject instance_eval(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        return ((RubyBasicObject)self).instance_eval(context, arg0, arg1, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject instance_eval(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return ((RubyBasicObject)self).instance_eval(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(optional=3, rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject instance_exec(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return ((RubyBasicObject)self).instance_exec(context, args2, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public static IRubyObject extend(IRubyObject self, IRubyObject[] args2) {
        return ((RubyBasicObject)self).extend(args2);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject send(ThreadContext context, IRubyObject self, Block block) {
        return ((RubyBasicObject)self).send(context, block);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject send(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        return ((RubyBasicObject)self).send(context, arg0, block);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject send(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        return ((RubyBasicObject)self).send(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject send(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return ((RubyBasicObject)self).send(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"send", "__send__"}, rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject send(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return ((RubyBasicObject)self).send(context, args2, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject send19(ThreadContext context, IRubyObject self, Block block) {
        return ((RubyBasicObject)self).send19(context, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject send19(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        return ((RubyBasicObject)self).send19(context, arg0, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject send19(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        return ((RubyBasicObject)self).send19(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject send19(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return ((RubyBasicObject)self).send19(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"send"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject send19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return ((RubyBasicObject)self).send19(context, args2, block);
    }

    @JRubyMethod(name={"nil?"})
    public static IRubyObject nil_p(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).nil_p(context);
    }

    @JRubyMethod(name={"=~"}, required=1, compat=CompatVersion.RUBY1_8)
    public static IRubyObject op_match(ThreadContext context, IRubyObject self, IRubyObject arg2) {
        return ((RubyBasicObject)self).op_match(context, arg2);
    }

    @JRubyMethod(name={"=~"}, required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject op_match19(ThreadContext context, IRubyObject self, IRubyObject arg2) {
        return ((RubyBasicObject)self).op_match19(context, arg2);
    }

    @JRubyMethod(name={"!~"}, required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject op_not_match(ThreadContext context, IRubyObject self, IRubyObject arg2) {
        return ((RubyBasicObject)self).op_not_match(context, arg2);
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public static IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject self, IRubyObject name2) {
        return ((RubyBasicObject)self).instance_variable_defined_p(context, name2);
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public static IRubyObject instance_variable_get(ThreadContext context, IRubyObject self, IRubyObject name2) {
        return ((RubyBasicObject)self).instance_variable_get(context, name2);
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public static IRubyObject instance_variable_set(IRubyObject self, IRubyObject name2, IRubyObject value2) {
        return ((RubyBasicObject)self).instance_variable_set(name2, value2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject remove_instance_variable(ThreadContext context, IRubyObject self, IRubyObject name2, Block block) {
        return ((RubyBasicObject)self).remove_instance_variable(context, name2, block);
    }

    @JRubyMethod(name={"instance_variables"})
    public static RubyArray instance_variables(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).instance_variables(context);
    }

    @JRubyMethod(name={"instance_variables"}, compat=CompatVersion.RUBY1_9)
    public static RubyArray instance_variables19(ThreadContext context, IRubyObject self) {
        return ((RubyBasicObject)self).instance_variables19(context);
    }

    private static abstract class Uncaught {
        private Uncaught() {
        }

        public abstract RaiseException uncaughtThrow(Ruby var1, String var2, IRubyObject var3);
    }

    private static abstract class EvalBinding {
        private EvalBinding() {
        }

        public abstract Binding convertToBinding(IRubyObject var1);
    }

    public static abstract class MethodMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        public MethodMissingMethod(RubyModule implementationClass) {
            super(implementationClass, Visibility.PRIVATE, CallConfiguration.FrameFullScopeNone);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            IRubyObject iRubyObject;
            try {
                this.preFrameOnly(context, self, name2, block);
                iRubyObject = this.methodMissing(context, self, clazz, name2, args2, block);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                MethodMissingMethod.postFrameOnly(context);
                throw throwable;
            }
            MethodMissingMethod.postFrameOnly(context);
            return iRubyObject;
        }

        public abstract IRubyObject methodMissing(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);
    }
}

