/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelectionPanel
extends JPanel {
    private JTextField[] tfLatLon = null;
    private final JTextField tfOsmUrl = new JTextField();

    protected void buildInputFields() {
        this.tfLatLon = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.tfLatLon[i] = new JTextField(11);
            this.tfLatLon[i].setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            SelectAllOnFocusGainedDecorator.decorate(this.tfLatLon[i]);
        }
        LatitudeValidator.decorate(this.tfLatLon[0]);
        LatitudeValidator.decorate(this.tfLatLon[2]);
        LongitudeValidator.decorate(this.tfLatLon[1]);
        LongitudeValidator.decorate(this.tfLatLon[3]);
    }

    protected void build() {
        this.buildInputFields();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusGainedDecorator());
        this.add((Component)new JLabel(I18n.tr("Min. latitude")), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[0], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Min. longitude")), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[1], GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Max. latitude")), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[2], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Max. longitude")), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[3], GBC.eol());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 4;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(10, 0, 0, 3);
        this.add((Component)new JMultilineLabel(I18n.tr("URL from www.openstreetmap.org (you can paste a download URL here to specify a bounding box)")), gc);
        gc.gridy = 3;
        gc.insets = new Insets(3, 0, 0, 3);
        this.add((Component)this.tfOsmUrl, gc);
        this.tfOsmUrl.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent e) {
                OsmUrlPopup popup = new OsmUrlPopup();
                popup.show(BoundingBoxSelectionPanel.this.tfOsmUrl, e.getX(), e.getY());
            }
        });
    }

    public BoundingBoxSelectionPanel() {
        this.build();
    }

    public void setBoundingBox(Bounds area) {
        this.updateBboxFields(area);
    }

    public Bounds getBoundingBox() {
        double maxlat;
        double maxlon;
        double minlat;
        double minlon;
        try {
            minlon = Double.parseDouble(this.tfLatLon[0].getText().trim());
            minlat = Double.parseDouble(this.tfLatLon[1].getText().trim());
            maxlon = Double.parseDouble(this.tfLatLon[2].getText().trim());
            maxlat = Double.parseDouble(this.tfLatLon[3].getText().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (!(LatLon.isValidLon(minlon) && LatLon.isValidLon(maxlon) && LatLon.isValidLat(minlat) && LatLon.isValidLat(maxlat))) {
            return null;
        }
        if (minlon > maxlon) {
            return null;
        }
        if (minlat > maxlat) {
            return null;
        }
        return new Bounds(minlon, minlat, maxlon, maxlat);
    }

    private boolean parseURL() {
        Bounds b = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (b == null) {
            return false;
        }
        this.updateBboxFields(b);
        return true;
    }

    private void updateBboxFields(Bounds area) {
        if (area == null) {
            return;
        }
        this.tfLatLon[0].setText(area.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[1].setText(area.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[2].setText(area.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[3].setText(area.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES));
    }

    class OsmUrlPopup
    extends JPopupMenu {
        public OsmUrlPopup() {
            this.add(new PasteUrlAction());
        }
    }

    class PasteUrlAction
    extends AbstractAction
    implements FlavorListener {
        public PasteUrlAction() {
            this.putValue("Name", I18n.tr("Paste"));
            this.putValue("SmallIcon", ImageProvider.get("paste"));
            this.putValue("ShortDescription", I18n.tr("Paste URL from clipboard"));
            Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
        }

        protected String getClipboardContent() {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                    return text;
                }
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            String content = this.getClipboardContent();
            if (content != null) {
                BoundingBoxSelectionPanel.this.tfOsmUrl.setText(content);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getClipboardContent() != null);
        }

        public void flavorsChanged(FlavorEvent e) {
            this.updateEnabledState();
        }
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        public void changedUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        public void insertUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        public void removeUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }
    }

    private static class LongitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent tc) {
            new LongitudeValidator(tc);
        }

        public LongitudeValidator(JTextComponent tc) {
            super(tc);
        }

        public void validate() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLon(value)) {
                this.feedbackInvalid(I18n.tr("Value for longitude in range [-180,180] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        public boolean isValid() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return LatLon.isValidLon(value);
        }
    }

    private static class LatitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent tc) {
            new LatitudeValidator(tc);
        }

        public LatitudeValidator(JTextComponent tc) {
            super(tc);
        }

        public void validate() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLat(value)) {
                this.feedbackInvalid(I18n.tr("Value for latitude in range [-90,90] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        public boolean isValid() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return LatLon.isValidLat(value);
        }
    }
}

