/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;

public class HelpContentReader {
    private String baseUrl;

    public HelpContentReader(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String fetchHelpTopicContent(String helpTopicUrl, boolean dotest) throws HelpContentReaderException {
        URL url = null;
        HttpURLConnection con = null;
        BufferedReader in = null;
        try {
            url = new URL(helpTopicUrl);
            con = (HttpURLConnection)url.openConnection();
            con.connect();
            in = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            String string = this.prepareHelpContent(in, dotest);
            return string;
        }
        catch (MalformedURLException e) {
            throw new HelpContentReaderException(e);
        }
        catch (IOException e) {
            HelpContentReaderException ex = new HelpContentReaderException(e);
            if (con != null) {
                try {
                    ex.setResponseCode(con.getResponseCode());
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String prepareHelpContent(BufferedReader in, boolean dotest) throws HelpContentReaderException {
        boolean isInContent = false;
        boolean isInTranslationsSideBar = false;
        boolean isExistingHelpPage = false;
        StringBuffer sball = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        try {
            String line = in.readLine();
            while (line != null) {
                block20: {
                    block14: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                sball.append(line);
                                                sball.append("\n");
                                                if (!line.contains("<div id=\"searchable\">")) break block13;
                                                isInContent = true;
                                                break block14;
                                            }
                                            if (!line.contains("<div class=\"wiki-toc trac-nav\"")) break block15;
                                            isInTranslationsSideBar = true;
                                            break block14;
                                        }
                                        if (!line.contains("<div class=\"wikipage searchable\">")) break block16;
                                        isInContent = true;
                                        break block14;
                                    }
                                    if (!line.contains("<div class=\"buttons\">")) break block17;
                                    isInContent = false;
                                    break block14;
                                }
                                if (!line.contains("<h3>Attachments</h3>")) break block18;
                                isInContent = false;
                                break block14;
                            }
                            if (!line.contains("<div id=\"attachments\">")) break block19;
                            isInContent = false;
                            break block14;
                        }
                        if (line.contains("<div class=\"trac-modifiedby\">")) break block20;
                        if (line.contains("<input type=\"submit\" name=\"attachfilebutton\"")) {
                            isExistingHelpPage = true;
                        }
                    }
                    if (isInContent && !isInTranslationsSideBar) {
                        line = line.replaceAll("<img ([^>]*)src=\"/", "<img border=\"0\" \\1src=\"" + this.baseUrl + "/").replaceAll("href=\"/", "href=\"" + this.baseUrl + "/").replaceAll(" />", ">");
                        sb.append(line);
                        sb.append("\n");
                    } else if (isInTranslationsSideBar && line.contains("</div>")) {
                        isInTranslationsSideBar = false;
                    }
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new HelpContentReaderException(e);
        }
        if (!dotest && sb.length() == 0) {
            sb = sball;
        } else if (dotest && !isExistingHelpPage) {
            throw new MissingHelpContentException();
        }
        sb.insert(0, "<html>");
        sb.append("<html>");
        return sb.toString();
    }
}

