/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.openstreetmap.josm.tools.I18n;

public class QuadStateCheckBox
extends JCheckBox {
    private final QuadStateDecorator model;
    private State[] allowed;

    public QuadStateCheckBox(String text, Icon icon, State initial, State[] allowed) {
        super(text, icon);
        this.allowed = allowed;
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new QuadStateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public QuadStateCheckBox(String text, State initial, State[] allowed) {
        this(text, null, initial, allowed);
    }

    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean b) {
        if (b) {
            this.setState(State.SELECTED);
        } else {
            this.setState(State.NOT_SELECTED);
        }
    }

    private class QuadStateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private QuadStateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == State.NOT_SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("false: the property is explicitly switched off"));
            } else if (state == State.SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("true: the property is explicitly switched on"));
            } else if (state == State.PARTIAL) {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("partial: different selected objects have different values, do not change"));
            } else {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("unset: do not set this property on the selected objects"));
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.PARTIAL;
            }
            if (!this.isSelected() && !this.isArmed()) {
                return State.NOT_SELECTED;
            }
            return State.UNSET;
        }

        private void nextState() {
            State current = this.getState();
            for (int i = 0; i < QuadStateCheckBox.this.allowed.length; ++i) {
                if (QuadStateCheckBox.this.allowed[i] != current) continue;
                this.setState(i == QuadStateCheckBox.this.allowed.length - 1 ? QuadStateCheckBox.this.allowed[0] : QuadStateCheckBox.this.allowed[i + 1]);
                break;
            }
        }

        public void setArmed(boolean b) {
        }

        public void setSelected(boolean b) {
        }

        public void setPressed(boolean b) {
        }

        public void setEnabled(boolean b) {
            QuadStateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_SELECTED,
        SELECTED,
        UNSET,
        PARTIAL;

    }
}

