/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2SubGrid;
import org.openstreetmap.josm.data.projection.NTV2Util;

public class NTV2GridShiftFile
implements Serializable {
    private String overviewHeaderCountId;
    private int overviewHeaderCount;
    private int subGridHeaderCount;
    private int subGridCount;
    private String shiftType;
    private String version;
    private String fromEllipsoid = "";
    private String toEllipsoid = "";
    private double fromSemiMajorAxis;
    private double fromSemiMinorAxis;
    private double toSemiMajorAxis;
    private double toSemiMinorAxis;
    private NTV2SubGrid[] topLevelSubGrid;
    private NTV2SubGrid lastSubGrid;

    public void loadGridShiftFile(InputStream in, boolean loadAccuracy) throws IOException {
        byte[] b8 = new byte[8];
        boolean bigEndian = true;
        this.fromEllipsoid = "";
        this.toEllipsoid = "";
        this.topLevelSubGrid = null;
        in.read(b8);
        this.overviewHeaderCountId = new String(b8);
        if (!"NUM_OREC".equals(this.overviewHeaderCountId)) {
            throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
        }
        in.read(b8);
        this.overviewHeaderCount = NTV2Util.getIntBE(b8, 0);
        if (this.overviewHeaderCount == 11) {
            bigEndian = true;
        } else {
            this.overviewHeaderCount = NTV2Util.getIntLE(b8, 0);
            if (this.overviewHeaderCount == 11) {
                bigEndian = false;
            } else {
                throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
            }
        }
        in.read(b8);
        in.read(b8);
        this.subGridHeaderCount = NTV2Util.getInt(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.subGridCount = NTV2Util.getInt(b8, bigEndian);
        NTV2SubGrid[] subGrid = new NTV2SubGrid[this.subGridCount];
        in.read(b8);
        in.read(b8);
        this.shiftType = new String(b8);
        in.read(b8);
        in.read(b8);
        this.version = new String(b8);
        in.read(b8);
        in.read(b8);
        this.fromEllipsoid = new String(b8);
        in.read(b8);
        in.read(b8);
        this.toEllipsoid = new String(b8);
        in.read(b8);
        in.read(b8);
        this.fromSemiMajorAxis = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.fromSemiMinorAxis = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.toSemiMajorAxis = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.toSemiMinorAxis = NTV2Util.getDouble(b8, bigEndian);
        for (int i = 0; i < this.subGridCount; ++i) {
            subGrid[i] = new NTV2SubGrid(in, bigEndian, loadAccuracy);
        }
        this.topLevelSubGrid = this.createSubGridTree(subGrid);
        this.lastSubGrid = this.topLevelSubGrid[0];
        in.close();
    }

    private NTV2SubGrid[] createSubGridTree(NTV2SubGrid[] subGrid) {
        int topLevelCount = 0;
        HashMap subGridMap = new HashMap();
        for (int i = 0; i < subGrid.length; ++i) {
            if (subGrid[i].getParentSubGridName().equalsIgnoreCase("NONE")) {
                ++topLevelCount;
            }
            subGridMap.put(subGrid[i].getSubGridName(), new ArrayList());
        }
        NTV2SubGrid[] topLevelSubGrid = new NTV2SubGrid[topLevelCount];
        topLevelCount = 0;
        for (int i = 0; i < subGrid.length; ++i) {
            if (subGrid[i].getParentSubGridName().equalsIgnoreCase("NONE")) {
                topLevelSubGrid[topLevelCount++] = subGrid[i];
                continue;
            }
            ArrayList parent = (ArrayList)subGridMap.get(subGrid[i].getParentSubGridName());
            parent.add(subGrid[i]);
        }
        NTV2SubGrid[] nullArray = new NTV2SubGrid[]{};
        for (int i = 0; i < subGrid.length; ++i) {
            ArrayList subSubGrids = (ArrayList)subGridMap.get(subGrid[i].getSubGridName());
            if (subSubGrids.size() <= 0) continue;
            NTV2SubGrid[] subGridArray = subSubGrids.toArray(nullArray);
            subGrid[i].setSubGridArray(subGridArray);
        }
        return topLevelSubGrid;
    }

    public boolean gridShiftForward(NTV2GridShift gs) {
        NTV2SubGrid subGrid = this.lastSubGrid.getSubGridForCoord(gs.getLonPositiveWestSeconds(), gs.getLatSeconds());
        if (subGrid == null) {
            subGrid = this.getSubGrid(gs.getLonPositiveWestSeconds(), gs.getLatSeconds());
        }
        if (subGrid == null) {
            return false;
        }
        subGrid.interpolateGridShift(gs);
        gs.setSubGridName(subGrid.getSubGridName());
        this.lastSubGrid = subGrid;
        return true;
    }

    public boolean gridShiftReverse(NTV2GridShift gs) {
        NTV2GridShift forwardGs = new NTV2GridShift();
        forwardGs.setLonPositiveWestSeconds(gs.getLonPositiveWestSeconds());
        forwardGs.setLatSeconds(gs.getLatSeconds());
        for (int i = 0; i < 4; ++i) {
            if (!this.gridShiftForward(forwardGs)) {
                return false;
            }
            forwardGs.setLonPositiveWestSeconds(gs.getLonPositiveWestSeconds() - forwardGs.getLonShiftPositiveWestSeconds());
            forwardGs.setLatSeconds(gs.getLatSeconds() - forwardGs.getLatShiftSeconds());
        }
        gs.setLonShiftPositiveWestSeconds(-forwardGs.getLonShiftPositiveWestSeconds());
        gs.setLatShiftSeconds(-forwardGs.getLatShiftSeconds());
        gs.setLonAccuracyAvailable(forwardGs.isLonAccuracyAvailable());
        if (forwardGs.isLonAccuracyAvailable()) {
            gs.setLonAccuracySeconds(forwardGs.getLonAccuracySeconds());
        }
        gs.setLatAccuracyAvailable(forwardGs.isLatAccuracyAvailable());
        if (forwardGs.isLatAccuracyAvailable()) {
            gs.setLatAccuracySeconds(forwardGs.getLatAccuracySeconds());
        }
        return true;
    }

    private NTV2SubGrid getSubGrid(double lon, double lat) {
        NTV2SubGrid sub = null;
        for (int i = 0; i < this.topLevelSubGrid.length && (sub = this.topLevelSubGrid[i].getSubGridForCoord(lon, lat)) == null; ++i) {
        }
        return sub;
    }

    public boolean isLoaded() {
        return this.topLevelSubGrid != null;
    }

    public void unload() {
        this.topLevelSubGrid = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Headers  : ");
        buf.append(this.overviewHeaderCount);
        buf.append("\nSub Hdrs : ");
        buf.append(this.subGridHeaderCount);
        buf.append("\nSub Grids: ");
        buf.append(this.subGridCount);
        buf.append("\nType     : ");
        buf.append(this.shiftType);
        buf.append("\nVersion  : ");
        buf.append(this.version);
        buf.append("\nFr Ellpsd: ");
        buf.append(this.fromEllipsoid);
        buf.append("\nTo Ellpsd: ");
        buf.append(this.toEllipsoid);
        buf.append("\nFr Maj Ax: ");
        buf.append(this.fromSemiMajorAxis);
        buf.append("\nFr Min Ax: ");
        buf.append(this.fromSemiMinorAxis);
        buf.append("\nTo Maj Ax: ");
        buf.append(this.toSemiMajorAxis);
        buf.append("\nTo Min Ax: ");
        buf.append(this.toSemiMinorAxis);
        return buf.toString();
    }

    public NTV2SubGrid[] getSubGridTree() {
        NTV2SubGrid[] clone = new NTV2SubGrid[this.topLevelSubGrid.length];
        for (int i = 0; i < this.topLevelSubGrid.length; ++i) {
            clone[i] = (NTV2SubGrid)this.topLevelSubGrid[i].clone();
        }
        return clone;
    }

    public String getFromEllipsoid() {
        return this.fromEllipsoid;
    }

    public String getToEllipsoid() {
        return this.toEllipsoid;
    }
}

