/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

class ZipConstants {
    static final int METHOD_STORED = 0;
    static final int METHOD_DEFLATED = 8;
    static final int METHOD_DEFLATED64 = 9;
    static final int METHOD_BZIP2 = 12;
    static final int METHOD_LZMA = 14;
    static final int METHOD_LZ77 = 19;
    static final int METHOD_AES = 99;
    static final int FLAG_ENCRYPTED = 1;
    static final int FLAG_DATADESCR = 8;
    static final int FLAG_EFS = 2048;
    static long LOCSIG = 67324752L;
    static long EXTSIG = 134695760L;
    static long CENSIG = 33639248L;
    static long ENDSIG = 101010256L;
    static final int LOCHDR = 30;
    static final int EXTHDR = 16;
    static final int CENHDR = 46;
    static final int ENDHDR = 22;
    static final int LOCVER = 4;
    static final int LOCFLG = 6;
    static final int LOCHOW = 8;
    static final int LOCTIM = 10;
    static final int LOCCRC = 14;
    static final int LOCSIZ = 18;
    static final int LOCLEN = 22;
    static final int LOCNAM = 26;
    static final int LOCEXT = 28;
    static final int EXTCRC = 4;
    static final int EXTSIZ = 8;
    static final int EXTLEN = 12;
    static final int CENVEM = 4;
    static final int CENVER = 6;
    static final int CENFLG = 8;
    static final int CENHOW = 10;
    static final int CENTIM = 12;
    static final int CENCRC = 16;
    static final int CENSIZ = 20;
    static final int CENLEN = 24;
    static final int CENNAM = 28;
    static final int CENEXT = 30;
    static final int CENCOM = 32;
    static final int CENDSK = 34;
    static final int CENATT = 36;
    static final int CENATX = 38;
    static final int CENOFF = 42;
    static final int ENDSUB = 8;
    static final int ENDTOT = 10;
    static final int ENDSIZ = 12;
    static final int ENDOFF = 16;
    static final int ENDCOM = 20;
    static final long ZIP64_ENDSIG = 101075792L;
    static final long ZIP64_LOCSIG = 117853008L;
    static final int ZIP64_ENDHDR = 56;
    static final int ZIP64_LOCHDR = 20;
    static final int ZIP64_EXTHDR = 24;
    static final int ZIP64_EXTID = 1;
    static final int ZIP64_MINVAL32 = 65535;
    static final long ZIP64_MINVAL = 0xFFFFFFFFL;
    static final int ZIP64_ENDLEN = 4;
    static final int ZIP64_ENDVEM = 12;
    static final int ZIP64_ENDVER = 14;
    static final int ZIP64_ENDNMD = 16;
    static final int ZIP64_ENDDSK = 20;
    static final int ZIP64_ENDTOD = 24;
    static final int ZIP64_ENDTOT = 32;
    static final int ZIP64_ENDSIZ = 40;
    static final int ZIP64_ENDOFF = 48;
    static final int ZIP64_ENDEXT = 56;
    static final int ZIP64_LOCDSK = 4;
    static final int ZIP64_LOCOFF = 8;
    static final int ZIP64_LOCTOT = 16;
    static final int ZIP64_EXTCRC = 4;
    static final int ZIP64_EXTSIZ = 8;
    static final int ZIP64_EXTLEN = 16;
    static final int EXTID_ZIP64 = 1;
    static final int EXTID_NTFS = 10;
    static final int EXTID_UNIX = 13;
    static final int EXTID_EFS = 23;
    static final int EXTID_EXTT = 21589;
    static final long END_MAXLEN = 65557L;
    static final int READBLOCKSZ = 128;

    ZipConstants() {
    }

    static final int CH(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    static final int SH(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static final long LG(byte[] byArray, int n) {
        return (long)(ZipConstants.SH(byArray, n) | ZipConstants.SH(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    static final long LL(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n) | ZipConstants.LG(byArray, n + 4) << 32;
    }

    static final long GETSIG(byte[] byArray) {
        return ZipConstants.LG(byArray, 0);
    }

    static final long LOCSIG(byte[] byArray) {
        return ZipConstants.LG(byArray, 0);
    }

    static final int LOCVER(byte[] byArray) {
        return ZipConstants.SH(byArray, 4);
    }

    static final int LOCFLG(byte[] byArray) {
        return ZipConstants.SH(byArray, 6);
    }

    static final int LOCHOW(byte[] byArray) {
        return ZipConstants.SH(byArray, 8);
    }

    static final long LOCTIM(byte[] byArray) {
        return ZipConstants.LG(byArray, 10);
    }

    static final long LOCCRC(byte[] byArray) {
        return ZipConstants.LG(byArray, 14);
    }

    static final long LOCSIZ(byte[] byArray) {
        return ZipConstants.LG(byArray, 18);
    }

    static final long LOCLEN(byte[] byArray) {
        return ZipConstants.LG(byArray, 22);
    }

    static final int LOCNAM(byte[] byArray) {
        return ZipConstants.SH(byArray, 26);
    }

    static final int LOCEXT(byte[] byArray) {
        return ZipConstants.SH(byArray, 28);
    }

    static final long EXTCRC(byte[] byArray) {
        return ZipConstants.LG(byArray, 4);
    }

    static final long EXTSIZ(byte[] byArray) {
        return ZipConstants.LG(byArray, 8);
    }

    static final long EXTLEN(byte[] byArray) {
        return ZipConstants.LG(byArray, 12);
    }

    static final int ENDSUB(byte[] byArray) {
        return ZipConstants.SH(byArray, 8);
    }

    static final int ENDTOT(byte[] byArray) {
        return ZipConstants.SH(byArray, 10);
    }

    static final long ENDSIZ(byte[] byArray) {
        return ZipConstants.LG(byArray, 12);
    }

    static final long ENDOFF(byte[] byArray) {
        return ZipConstants.LG(byArray, 16);
    }

    static final int ENDCOM(byte[] byArray) {
        return ZipConstants.SH(byArray, 20);
    }

    static final int ENDCOM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 20);
    }

    static final long ZIP64_ENDTOD(byte[] byArray) {
        return ZipConstants.LL(byArray, 24);
    }

    static final long ZIP64_ENDTOT(byte[] byArray) {
        return ZipConstants.LL(byArray, 32);
    }

    static final long ZIP64_ENDSIZ(byte[] byArray) {
        return ZipConstants.LL(byArray, 40);
    }

    static final long ZIP64_ENDOFF(byte[] byArray) {
        return ZipConstants.LL(byArray, 48);
    }

    static final long ZIP64_LOCOFF(byte[] byArray) {
        return ZipConstants.LL(byArray, 8);
    }

    static final long CENSIG(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 0);
    }

    static final int CENVEM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 4);
    }

    static final int CENVER(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 6);
    }

    static final int CENFLG(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 8);
    }

    static final int CENHOW(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 10);
    }

    static final long CENTIM(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 12);
    }

    static final long CENCRC(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 16);
    }

    static final long CENSIZ(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 20);
    }

    static final long CENLEN(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 24);
    }

    static final int CENNAM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 28);
    }

    static final int CENEXT(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 30);
    }

    static final int CENCOM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 32);
    }

    static final int CENDSK(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 34);
    }

    static final int CENATT(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 36);
    }

    static final long CENATX(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 38);
    }

    static final long CENOFF(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 42);
    }
}

