/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic.amd64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;

public class AMD64CFrame
extends BasicCFrame {
    private Address rbp;
    private Address pc;
    private static final int ADDRESS_SIZE = 8;

    public AMD64CFrame(CDebugger dbg, Address rbp, Address pc) {
        super(dbg);
        this.rbp = rbp;
        this.pc = pc;
    }

    @Override
    public CFrame sender() {
        if (this.rbp == null) {
            return null;
        }
        Address nextRBP = this.rbp.getAddressAt(0L);
        if (nextRBP == null) {
            return null;
        }
        Address nextPC = this.rbp.getAddressAt(8L);
        if (nextPC == null) {
            return null;
        }
        return new AMD64CFrame(this.dbg(), nextRBP, nextPC);
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.rbp;
    }
}

