/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class TransferListenerAdapter
implements TransferListener {
    protected final MavenProgressIndicator myIndicator;
    private String myRepository;
    private String myResource;
    private long mySize;
    private long myProgress;

    public TransferListenerAdapter(MavenProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    public void transferInitiated(TransferEvent event) {
        this.myIndicator.checkCanceledNative();
    }

    public void transferStarted(TransferEvent event) {
        this.myRepository = event.getWagon().getRepository().getName();
        this.myResource = event.getResource().getName();
        this.mySize = event.getResource().getContentLength();
        this.myProgress = 0L;
        this.updateProgress();
    }

    private void updateProgress() {
        this.doUpdateProgress(this.myProgress / 1024L, this.mySize / 1024L);
    }

    protected void doUpdateProgress(long downloaded, long total) {
        this.myIndicator.setText2(ProjectBundle.message("maven.transfer.progress", downloaded, total == 0L ? "?" : Long.valueOf(total), this.myRepository, this.myResource));
    }

    public void transferProgress(TransferEvent event, byte[] bytes, int i) {
        this.myIndicator.checkCanceledNative();
        this.myProgress += (long)i;
        this.updateProgress();
    }

    public void transferCompleted(TransferEvent event) {
        this.addArtifactToIndex(event);
        this.myIndicator.checkCanceledNative();
        this.updateTiming(true);
    }

    public void transferError(TransferEvent event) {
        this.myIndicator.checkCanceledNative();
        this.updateTiming(false);
    }

    public void debug(String s) {
        this.myIndicator.checkCanceledNative();
    }

    private void updateTiming(boolean ok) {
    }

    private void addArtifactToIndex(TransferEvent event) {
        MavenIndicesManager.getInstance().addArtifact(event.getLocalFile(), event.getResource().getName());
    }
}

