/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassNameSameAsAncestorNameInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.same.as.ancestor.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ClassNameSameAsAncestorNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.same.as.ancestor.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ClassNameSameAsAncestorNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameSameAsAncestorNameVisitor();
    }

    private static class ClassNameSameAsAncestorNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameSameAsAncestorNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] supers;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/ClassNameSameAsAncestorNameInspection$ClassNameSameAsAncestorNameVisitor.visitClass must not be null");
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            HashSet<PsiClass> alreadyVisited = new HashSet<PsiClass>(8);
            for (PsiClass aSuper : supers = aClass.getSupers()) {
                if (!ClassNameSameAsAncestorNameVisitor.hasMatchingName(aSuper, className, alreadyVisited)) continue;
                this.registerClassError(aClass, new Object[0]);
            }
        }

        private static boolean hasMatchingName(PsiClass aSuper, String className, Set<PsiClass> alreadyVisited) {
            PsiClass[] supers;
            if (aSuper == null) {
                return false;
            }
            if (alreadyVisited.contains(aSuper)) {
                return false;
            }
            alreadyVisited.add(aSuper);
            String superName = aSuper.getName();
            if (className.equals(superName)) {
                return true;
            }
            for (PsiClass aSupers : supers = aSuper.getSupers()) {
                if (!ClassNameSameAsAncestorNameVisitor.hasMatchingName(aSupers, className, alreadyVisited)) continue;
                return true;
            }
            return false;
        }
    }
}

