/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.controlflow.ConditionalUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class TrivialIfInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/TrivialIfInspection.getID must not return null");
        }
        return "RedundantIfStatement";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/TrivialIfInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/TrivialIfInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TrivialIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
            PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
            PsiJavaToken thenSign = thenExpression.getOperationSign();
            PsiJavaToken elseSign = elseExpression.getOperationSign();
            IElementType thenTokenType = thenSign.getTokenType();
            if (!thenTokenType.equals(elseSign.getTokenType())) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
            PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
            PsiJavaToken thenSign = thenExpression.getOperationSign();
            PsiJavaToken elseSign = elseExpression.getOperationSign();
            IElementType thenTokenType = thenSign.getTokenType();
            if (!thenTokenType.equals(elseSign.getTokenType())) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
            PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
            PsiJavaToken thenSign = thenExpression.getOperationSign();
            PsiJavaToken elseSign = elseExpression.getOperationSign();
            IElementType thenTokenType = thenSign.getTokenType();
            if (!thenTokenType.equals(elseSign.getTokenType())) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ControlFlowUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
            PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
            PsiJavaToken thenSign = thenExpression.getOperationSign();
            PsiJavaToken elseSign = elseExpression.getOperationSign();
            IElementType thenTokenType = thenSign.getTokenType();
            if (!thenTokenType.equals(elseSign.getTokenType())) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (PsiUtil.hasErrorElementChild((PsiElement)ifStatement)) {
                return;
            }
            if (TrivialIfInspection.isSimplifiableAssignment(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableReturn(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableImplicitReturn(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableReturnNegated(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
            }
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            if (TrivialIfInspection.isSimplifiableAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableAssignment(statement);
            } else if (TrivialIfInspection.isSimplifiableReturn(statement)) {
                TrivialIfFix.repaceSimplifiableReturn(statement);
            } else if (TrivialIfInspection.isSimplifiableImplicitReturn(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturn(statement);
            } else if (TrivialIfInspection.isSimplifiableAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            } else if (TrivialIfInspection.isSimplifiableReturnNegated(statement)) {
                TrivialIfFix.repaceSimplifiableReturnNegated(statement);
            } else if (TrivialIfInspection.isSimplifiableImplicitReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturnNegated(statement);
            } else if (TrivialIfInspection.isSimplifiableImplicitAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignment(statement);
            } else if (TrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignmentNegated(statement);
            }
        }

        private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = condition.getText();
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((PsiStatement)statement, newStatement);
            assert (nextStatement != null);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void repaceSimplifiableReturn(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = condition.getText();
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((PsiStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignment(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = condition.getText();
            PsiStatement thenBranch = statement.getThenBranch();
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiJavaToken operator = assignmentExpression.getOperationSign();
            String operand = operator.getText();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((PsiStatement)statement, lhsText + operand + conditionText + ';');
        }

        private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (prevStatement == null) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = condition.getText();
            PsiStatement thenBranch = statement.getThenBranch();
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiJavaToken operator = assignmentExpression.getOperationSign();
            String operand = operator.getText();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((PsiStatement)statement, lhsText + operand + conditionText + ';');
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitAssignmentNegated(PsiIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiJavaToken operator = assignmentExpression.getOperationSign();
            String operand = operator.getText();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((PsiStatement)statement, lhsText + operand + conditionText + ';');
            assert (prevStatement != null);
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitReturnNegated(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (nextStatement == null) {
                return;
            }
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((PsiStatement)statement, newStatement);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void repaceSimplifiableReturnNegated(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((PsiStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignmentNegated(PsiIfStatement statement) throws IncorrectOperationException {
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiJavaToken operator = assignmentExpression.getOperationSign();
            String operand = operator.getText();
            PsiExpression lhs = assignmentExpression.getLExpression();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((PsiStatement)statement, lhsText + operand + conditionText + ';');
        }
    }
}

