/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.Convertor;
import com.intellij.util.io.EqualityPolicy;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.BranchConfigurationDialog;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.QuickMerge;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CopiesPanel {
    private final Project myProject;
    private MessageBusConnection myConnection;
    private SvnVcs myVcs;
    private JPanel myPanel;
    private JComponent myHolder;
    private LinkLabel myRefreshLabel;
    private List<OverrideEqualsWrapper<WCInfo>> myCurrentInfoList;

    public CopiesPanel(Project project) {
        this.myProject = project;
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myCurrentInfoList = null;
        final Runnable focus = new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)CopiesPanel.this.myProject).requestFocus((Component)CopiesPanel.this.myRefreshLabel, true);
            }
        };
        final Runnable refreshView = new Runnable(){

            @Override
            public void run() {
                List<WCInfo> infoList = CopiesPanel.this.myVcs.getAllWcInfos();
                if (CopiesPanel.this.myCurrentInfoList != null) {
                    List newList = ObjectsConvertor.convert(infoList, (Convertor)new Convertor<WCInfo, OverrideEqualsWrapper<WCInfo>>(){

                        public OverrideEqualsWrapper<WCInfo> convert(WCInfo o) {
                            return new OverrideEqualsWrapper<WCInfo>(InfoEqualityPolicy.getInstance(), o);
                        }
                    }, (NotNullFunction)ObjectsConvertor.NOT_NULL);
                    if (Comparing.haveEqualElements((Collection)newList, (Collection)CopiesPanel.this.myCurrentInfoList)) {
                        CopiesPanel.this.myRefreshLabel.setEnabled(true);
                        return;
                    }
                    CopiesPanel.this.myCurrentInfoList = newList;
                }
                Collections.sort(infoList, WCComparator.getInstance());
                CopiesPanel.this.updateList(infoList);
                CopiesPanel.this.myRefreshLabel.setEnabled(true);
                SwingUtilities.invokeLater(focus);
            }
        };
        this.myConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(refreshView, ModalityState.NON_MODAL);
            }
        });
        JPanel holderPanel = new JPanel(new BorderLayout());
        this.myPanel = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPanel, "North");
        holderPanel.add((Component)panel, "West");
        this.myRefreshLabel = new LinkLabel("Refresh", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                if (CopiesPanel.this.myRefreshLabel.isEnabled()) {
                    CopiesPanel.this.myVcs.invokeRefreshSvnRoots(true);
                    CopiesPanel.this.myRefreshLabel.setEnabled(false);
                }
            }
        });
        this.myHolder = new JScrollPane(holderPanel);
        this.setFocusableForLinks(this.myRefreshLabel);
        refreshView.run();
        this.initView();
    }

    public JComponent getPrefferedFocusComponent() {
        return this.myRefreshLabel;
    }

    private JTextField createField(String text) {
        JTextField field = new JTextField(text);
        field.setBackground(UIUtil.getPanelBackgound());
        field.setEditable(false);
        field.setBorder(null);
        field.setFocusable(false);
        field.setHorizontalAlignment(4);
        field.setCaretPosition(0);
        return field;
    }

    private void updateList(List<WCInfo> infoList) {
        this.myPanel.removeAll();
        Insets nullIndent = new Insets(1, 3, 1, 0);
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 0, 0), 0, 0);
        gb.insets.left = 4;
        this.myPanel.add((Component)this.myRefreshLabel, gb);
        gb.insets.left = 1;
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        Insets topIndent = new Insets(10, 3, 0, 0);
        for (final WCInfo wcInfo : infoList) {
            NestedCopyType type;
            JPanel copyPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, nullIndent, 0, 0);
            gb1.insets.top = 1;
            gb1.gridwidth = 3;
            gb.insets = topIndent;
            gb.fill = 2;
            ++gb.gridy;
            JPanel contForCopy = new JPanel(new BorderLayout());
            contForCopy.add((Component)copyPanel, "West");
            this.myPanel.add((Component)contForCopy, gb);
            JTextField path = this.createField(wcInfo.getPath());
            copyPanel.add((Component)path, gb1);
            path.setFont(path.getFont().deriveFont(1));
            gb1.insets = nullIndent;
            gb1.insets.top = 5;
            ++gb1.gridy;
            JTextField url = this.createField("URL: " + wcInfo.getRootUrl());
            copyPanel.add((Component)url, gb1);
            ++gb1.gridy;
            gb1.insets.top = 1;
            JTextField format = this.createField("Format: " + wcInfo.getFormat().getName());
            copyPanel.add((Component)format, gb1);
            gb1.gridx = 2;
            LinkLabel changeFormatLabel = new LinkLabel("Change", null, new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    CopiesPanel.this.changeFormat(wcInfo);
                }
            });
            copyPanel.add((Component)changeFormatLabel, gb1);
            this.setFocusableForLinks(changeFormatLabel);
            gb1.gridx = 0;
            ++gb1.gridy;
            JTextField depth = this.createField("Depth: " + wcInfo.getStickyDepth().getName());
            copyPanel.add((Component)depth, gb1);
            if (!SVNDepth.INFINITY.equals((Object)wcInfo.getStickyDepth())) {
                gb1.gridx = 2;
                LinkLabel fixDepthLabel = new LinkLabel("Make infinity", null, new LinkListener(){

                    public void linkSelected(LinkLabel aSource, Object aLinkData) {
                        int result = Messages.showDialog((Project)CopiesPanel.this.myVcs.getProject(), (String)("You are going to checkout into '" + wcInfo.getPath() + "' with 'infinity' depth.\n" + "This will update your working copy to HEAD revision as well."), (String)"Set working copy infinity depth", (String[])new String[]{"Ok", "Cancel"}, (int)0, (Icon)Messages.getWarningIcon());
                        if (result == 0) {
                            SvnCheckoutProvider.checkout(CopiesPanel.this.myVcs.getProject(), new File(wcInfo.getPath()), wcInfo.getRootUrl(), SVNRevision.HEAD, SVNDepth.INFINITY, false, null, wcInfo.getFormat());
                        }
                    }
                });
                copyPanel.add((Component)fixDepthLabel, gb1);
                this.setFocusableForLinks(fixDepthLabel);
                gb1.gridx = 0;
            }
            if (NestedCopyType.external.equals((Object)(type = wcInfo.getType())) || NestedCopyType.switched.equals((Object)type)) {
                ++gb1.gridy;
                JTextField whetherNested = this.createField(type.getName() + " copy");
                copyPanel.add((Component)whetherNested, gb1);
                whetherNested.setFont(whetherNested.getFont().deriveFont(2));
            }
            if (wcInfo.isIsWcRoot()) {
                ++gb1.gridy;
                JTextField whetherRoot = this.createField("Working copy root");
                copyPanel.add((Component)whetherRoot, gb1);
                whetherRoot.setFont(whetherRoot.getFont().deriveFont(2));
            }
            gb1.gridwidth = 1;
            gb1.insets.top = 5;
            ++gb1.gridy;
            VirtualFile vf = lfs.refreshAndFindFileByIoFile(new File(wcInfo.getPath()));
            final VirtualFile root = vf == null ? wcInfo.getVcsRoot() : vf;
            LinkLabel configureBranchesLabel = new LinkLabel("Configure Branches", null, new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    BranchConfigurationDialog.configureBranches(CopiesPanel.this.myProject, root, true);
                }
            });
            if (root == null) {
                configureBranchesLabel.setEnabled(false);
            }
            copyPanel.add((Component)configureBranchesLabel, gb1);
            this.setFocusableForLinks(configureBranchesLabel);
            ++gb1.gridy;
            final LinkLabel mergeLabel = new LinkLabel("Merge from...", null);
            mergeLabel.setListener(new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    CopiesPanel.this.mergeFrom(wcInfo, root, mergeLabel);
                }
            }, null);
            if (root == null) {
                mergeLabel.setEnabled(false);
            }
            Font font = mergeLabel.getFont();
            mergeLabel.setFont(font.deriveFont(1));
            mergeLabel.setForeground(mergeLabel.getForeground().darker());
            copyPanel.add((Component)mergeLabel, gb1);
            this.setFocusableForLinks(mergeLabel);
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private void mergeFrom(final WCInfo wcInfo, final VirtualFile root, LinkLabel mergeLabel) {
        SelectBranchPopup.showForBranchRoot(this.myProject, root, new SelectBranchPopup.BranchSelectedCallback(){

            @Override
            public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
                new QuickMerge(project, url, wcInfo, SVNPathUtil.tail((String)url), root).execute();
            }
        }, "Select branch", (Component)mergeLabel);
    }

    private void setFocusableForLinks(final LinkLabel label) {
        DottedBorder border = new DottedBorder(new Insets(1, 2, 1, 1), Color.black);
        label.setFocusable(true);
        label.addFocusListener((FocusListener)new FocusAdapter((Border)border){
            final /* synthetic */ Border val$border;
            {
                this.val$border = border;
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                label.setBorder(this.val$border);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                label.setBorder(null);
            }
        });
        label.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    label.doClick();
                }
            }
        });
    }

    private void changeFormat(WCInfo wcInfo) {
        ChangeFormatDialog dialog = new ChangeFormatDialog(this.myProject, new File(wcInfo.getPath()), false, !wcInfo.isIsWcRoot());
        dialog.setData(true, wcInfo.getFormat().getOption());
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        String newMode = dialog.getUpgradeMode();
        if (!wcInfo.getFormat().getOption().equals(newMode)) {
            WorkingCopyFormat newFormat = WorkingCopyFormat.getInstance(newMode);
            SvnFormatWorker task = new SvnFormatWorker(this.myProject, newFormat, wcInfo){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    CopiesPanel.this.myRefreshLabel.doClick();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private void initView() {
        this.myRefreshLabel.doClick();
    }

    public JComponent getComponent() {
        return this.myHolder;
    }

    private static class WCComparator
    implements Comparator<WCInfo> {
        private static final WCComparator ourComparator = new WCComparator();

        private WCComparator() {
        }

        public static WCComparator getInstance() {
            return ourComparator;
        }

        @Override
        public int compare(WCInfo o1, WCInfo o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private static class InfoEqualityPolicy
    implements EqualityPolicy<WCInfo> {
        private static final InfoEqualityPolicy ourInstance = new InfoEqualityPolicy();

        private InfoEqualityPolicy() {
        }

        public static InfoEqualityPolicy getInstance() {
            return ourInstance;
        }

        public int getHashCode(WCInfo value) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(value.getPath());
            builder.append(value.getUrl());
            builder.append((Object)value.getFormat());
            builder.append((Object)value.getType());
            builder.append(value.getStickyDepth());
            return builder.getCode();
        }

        public boolean isEqual(WCInfo val1, WCInfo val2) {
            if (val1 == val2) {
                return true;
            }
            if (val1 == null || val2 == null || val1.getClass() != val2.getClass()) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getFormat()), (Object)((Object)val2.getFormat()))) {
                return false;
            }
            if (!Comparing.equal((String)val1.getPath(), (String)val2.getPath())) {
                return false;
            }
            if (!Comparing.equal((Object)val1.getStickyDepth(), (Object)val2.getStickyDepth())) {
                return false;
            }
            if (!Comparing.equal((Object)((Object)val1.getType()), (Object)((Object)val2.getType()))) {
                return false;
            }
            return Comparing.equal((Object)val1.getUrl(), (Object)val2.getUrl());
        }

        private static class HashCodeBuilder {
            private int myCode = 0;

            private HashCodeBuilder() {
            }

            public void append(Object o) {
                this.myCode = 31 * this.myCode + (o != null ? o.hashCode() : 0);
            }

            public int getCode() {
                return this.myCode;
            }
        }
    }

    public static class OverrideEqualsWrapper<T> {
        private final EqualityPolicy<T> myPolicy;
        private final T myT;

        public OverrideEqualsWrapper(EqualityPolicy<T> policy, T t) {
            this.myPolicy = policy;
            this.myT = t;
        }

        public T getT() {
            return this.myT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideEqualsWrapper that = (OverrideEqualsWrapper)o;
            return this.myPolicy.isEqual(this.myT, that.getT());
        }

        public int hashCode() {
            return this.myPolicy.getHashCode(this.myT);
        }
    }
}

