/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentsUtil;
import java.awt.Component;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.CopiesPanel;

public class ShowSvnMapAction
extends AnAction
implements DumbAware {
    public ShowSvnMapAction() {
        super(SvnBundle.message("action.show.svn.map.text", new Object[0]));
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        presentation.setVisible(project != null);
        presentation.setEnabled(project != null);
        presentation.setDescription(SvnBundle.message("action.show.svn.map.description", new Object[0]));
        presentation.setIcon(IconLoader.getIcon((String)"/icons/ShowWorkingCopies.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        final CopiesPanel copiesPanel = new CopiesPanel(project);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = ContentFactory.SERVICE.getInstance().createContent(copiesPanel.getComponent(), SvnBundle.message("dialog.show.svn.map.title", new Object[0]), true);
        ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content, (boolean)true);
        toolWindow.activate(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)copiesPanel.getPrefferedFocusComponent(), true);
            }
        });
    }
}

