/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.CopyEventHandler;
import org.jetbrains.idea.svn.dialogs.CopyDialog;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class CopyAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.Subversion.Copy.text", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file == null) {
            return false;
        }
        return SvnStatusUtil.isUnderControl(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(final Project project, final SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        CopyDialog dialog = new CopyDialog(project, true, new File(file.getPath()));
        dialog.show();
        if (dialog.isOK()) {
            SVNURL parentUrl;
            SVNURL dstSvnUrl;
            SVNURL srcUrl;
            final String dstURL = dialog.getToURL();
            final SVNRevision revision = dialog.getRevision();
            final String comment = dialog.getComment();
            final Ref exception = new Ref();
            final boolean isSrcFile = dialog.isCopyFromWorkingCopy();
            final File srcFile = new File(dialog.getCopyFromPath());
            try {
                int rc;
                SVNWCClient wcClient = activeVcs.createWCClient();
                srcUrl = SVNURL.parseURIEncoded((String)dialog.getCopyFromUrl());
                dstSvnUrl = SVNURL.parseURIEncoded((String)dstURL);
                parentUrl = dstSvnUrl.removePathTail();
                if (!CopyAction.dirExists(project, parentUrl, wcClient) && (rc = Messages.showYesNoDialog((Project)project, (String)("The repository path '" + parentUrl + "' does not exist. Would you like to create it?"), (String)"Branch or Tag", (Icon)Messages.getQuestionIcon())) == 1) {
                    return;
                }
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            Runnable copyCommand = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                        SVNCopyClient client = activeVcs.createCopyClient();
                        if (progress != null) {
                            progress.setText(SvnBundle.message("progress.text.copy.to", dstURL));
                            client.setEventHandler((ISVNEventHandler)new CopyEventHandler(progress));
                        }
                        CopyAction.checkCreateDir(parentUrl, activeVcs, comment);
                        SVNCopySource[] copySource = new SVNCopySource[]{isSrcFile ? new SVNCopySource(revision, revision, srcFile) : new SVNCopySource(revision, revision, srcUrl)};
                        SVNCommitInfo result = client.doCopy(copySource, dstSvnUrl, false, true, true, comment, null);
                        if (result != null && result != SVNCommitInfo.NULL) {
                            WindowManager.getInstance().getStatusBar(project).setInfo(SvnBundle.message("status.text.comitted.revision", result.getNewRevision()));
                        }
                    }
                    catch (Exception e) {
                        exception.set((Object)e);
                    }
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(copyCommand, SvnBundle.message("progress.title.copy", new Object[0]), false, project);
            if (!exception.isNull()) {
                throw new VcsException((Throwable)exception.get());
            }
        }
    }

    private static void checkCreateDir(SVNURL url, SvnVcs activeVcs, String comment) throws SVNException, VcsException {
        SVNURL baseUrl = url;
        SVNWCClient client = activeVcs.createWCClient();
        ArrayList<SVNURL> dirsToCreate = new ArrayList<SVNURL>();
        while (!CopyAction.dirExists(activeVcs.getProject(), url, client)) {
            dirsToCreate.add(0, url);
            if ((url = url.removePathTail()).getPath().length() != 0) continue;
            throw new VcsException("Invalid repository root path for " + baseUrl);
        }
        SVNCommitClient commitClient = activeVcs.createCommitClient();
        commitClient.doMkDir(dirsToCreate.toArray(new SVNURL[dirsToCreate.size()]), comment);
    }

    private static boolean dirExists(Project project, final SVNURL url, final SVNWCClient client) throws SVNException {
        final Ref excRef = new Ref();
        final Ref resultRef = new Ref((Object)Boolean.TRUE);
        final Runnable taskImpl = new Runnable(){

            @Override
            public void run() {
                try {
                    client.doInfo(url, SVNRevision.UNDEFINED, SVNRevision.HEAD);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode().equals((Object)SVNErrorCode.RA_ILLEGAL_URL)) {
                        resultRef.set((Object)Boolean.FALSE);
                    }
                    excRef.set((Object)e);
                }
            }
        };
        Task.Backgroundable task = new Task.Backgroundable(project, "Checking target folder", false, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/actions/CopyAction$3.run must not be null");
                }
                taskImpl.run();
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)task);
        } else {
            taskImpl.run();
        }
        if (!excRef.isNull()) {
            throw (SVNException)((Object)excRef.get());
        }
        return (Boolean)resultRef.get();
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

