/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBinaryContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

class SvnContentRevision
implements ContentRevision {
    private final SvnVcs myVcs;
    protected final FilePath myFile;
    private SoftReference<String> myContent;
    private final SVNRevision myRevision;
    private final boolean myUseBaseRevision;

    protected SvnContentRevision(SvnVcs vcs, @NotNull FilePath file, SVNRevision revision, boolean useBaseRevision) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnContentRevision.<init> must not be null");
        }
        this.myVcs = vcs;
        this.myRevision = revision;
        this.myUseBaseRevision = useBaseRevision;
        this.myFile = file;
    }

    public static SvnContentRevision create(@NotNull SvnVcs vcs, @NotNull FilePath file, SVNRevision revision) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnContentRevision.create must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnContentRevision.create must not be null");
        }
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, true);
        }
        return new SvnContentRevision(vcs, file, revision, true);
    }

    public static SvnContentRevision createRemote(@NotNull SvnVcs vcs, @NotNull FilePath file, SVNRevision revision) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnContentRevision.createRemote must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnContentRevision.createRemote must not be null");
        }
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, false);
        }
        return new SvnContentRevision(vcs, file, revision, false);
    }

    @Nullable
    public String getContent() throws VcsException {
        String content;
        SoftReference<String> ref = this.myContent;
        String string = content = ref == null ? null : ref.get();
        if (content == null) {
            try {
                byte[] byteContent = this.getUpToDateBinaryContent();
                if (byteContent != null) {
                    content = new String(byteContent, this.myFile.getCharset().name());
                    this.myContent = new SoftReference<String>(content);
                }
            }
            catch (Exception ex) {
                throw new VcsException((Throwable)ex);
            }
        }
        return content;
    }

    @Nullable
    protected byte[] getUpToDateBinaryContent() throws SVNException, IOException {
        File file = this.myFile.getIOFile();
        File lock = new File(file.getParentFile(), SvnUtil.PATH_TO_LOCK_FILE);
        if (lock.exists()) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SVNWCClient wcClient = this.myVcs.createWCClient();
        wcClient.doGetFileContents(file, SVNRevision.UNDEFINED, this.myUseBaseRevision ? SVNRevision.BASE : this.myRevision, true, (OutputStream)buffer);
        buffer.close();
        return buffer.toByteArray();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnContentRevision.getFile must not return null");
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = new SvnRevisionNumber(this.myRevision);
        if (svnRevisionNumber == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnContentRevision.getRevisionNumber must not return null");
        }
        return svnRevisionNumber;
    }

    @NonNls
    public String toString() {
        return "SvnContentRevision:" + this.myFile.toString();
    }
}

