/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.Icons;
import java.awt.Component;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanguageInjectionSupport
extends LanguageInjectionSupport {
    @Override
    public boolean useDefaultInjector(PsiElement host) {
        return false;
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        return new BaseInjection(this.getId());
    }

    @Override
    public void setupPresentation(BaseInjection injection, SimpleColoredText presentation, boolean isSelected) {
        presentation.append(injection.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[0];
    }

    @Override
    public AnAction[] createAddActions(Project project, Consumer<BaseInjection> consumer) {
        if (!ApplicationManagerEx.getApplicationEx().isInternal()) {
            return AnAction.EMPTY_ARRAY;
        }
        return new AnAction[]{AbstractLanguageInjectionSupport.createDefaultAddAction(project, consumer, this)};
    }

    @Override
    public AnAction createEditAction(Project project, Factory<BaseInjection> producer) {
        return AbstractLanguageInjectionSupport.createDefaultEditAction(project, producer);
    }

    public static AnAction createDefaultEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (!ApplicationManagerEx.getApplicationEx().isInternal()) {
                    return;
                }
                BaseInjection originalInjection = (BaseInjection)producer.create();
                BaseInjection newInjection = AbstractLanguageInjectionSupport.showInjectionUI(project, originalInjection.copy());
                if (newInjection != null) {
                    originalInjection.copyFrom(newInjection);
                    originalInjection.initializePlaces(true);
                }
            }
        };
    }

    public static AnAction createDefaultAddAction(final Project project, final Consumer<BaseInjection> consumer, final AbstractLanguageInjectionSupport support) {
        return new AnAction("Generic " + StringUtil.capitalize((String)support.getId()), null, Icons.FILE_ICON){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection injection = new BaseInjection(support.getId());
                injection.setDisplayName("New " + support.getId() + " Injection");
                BaseInjection newInjection = AbstractLanguageInjectionSupport.showInjectionUI(project, injection);
                if (newInjection != null) {
                    consumer.consume((Object)injection);
                }
            }
        };
    }

    @Nullable
    private static BaseInjection showInjectionUI(Project project, BaseInjection injection) {
        final BaseInjectionPanel panel = new BaseInjectionPanel(injection, project);
        panel.reset();
        final DialogBuilder builder = new DialogBuilder(project);
        builder.setHelpId("reference.settings.injection.language.injection.settings.java.parameter");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setDimensionServiceKey("#org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionDialog");
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(new Runnable(){

            @Override
            public void run() {
                try {
                    panel.apply();
                    builder.getDialogWrapper().close(0);
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    String message = e.getMessage() + (cause != null ? "\n  " + cause.getMessage() : "");
                    Messages.showErrorDialog((Component)builder.getWindow(), (String)message, (String)"Unable to Save");
                }
            }
        });
        if (builder.show() == 0) {
            injection.initializePlaces(false);
            return injection;
        }
        return null;
    }
}

