/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class AddEditRemovePanel<T>
extends PanelWithButtons {
    private JTable myTable;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myRemoveButton;
    private TableModel myModel;
    private List<T> myData;
    private AbstractTableModel myTableModel;

    public AddEditRemovePanel(TableModel<T> model, List<T> data) {
        this(model, data, null);
    }

    public AddEditRemovePanel(TableModel<T> model, List<T> data, String labelText) {
        this.myModel = model;
        this.myData = data;
        this.$$$setupUI$$$();
        this.initPanel();
        this.updateButtons();
        if (labelText != null) {
            this.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), labelText));
        }
    }

    @Override
    protected String getLabelText() {
        return null;
    }

    @Override
    protected JComponent createMainComponent() {
        this.myTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return AddEditRemovePanel.this.myData != null ? AddEditRemovePanel.this.myData.size() : 0;
            }

            @Override
            public int getColumnCount() {
                return AddEditRemovePanel.this.myModel.getColumnCount();
            }

            @Override
            public String getColumnName(int column) {
                return AddEditRemovePanel.this.myModel.getColumnName(column);
            }

            public Class getColumnClass(int columnIndex) {
                return AddEditRemovePanel.this.myModel.getColumnClass(columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return AddEditRemovePanel.this.myModel.isEditable(columnIndex);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return AddEditRemovePanel.this.myModel.getField(AddEditRemovePanel.this.myData.get(rowIndex), columnIndex);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                AddEditRemovePanel.this.myModel.setValue(aValue, AddEditRemovePanel.this.myData.get(rowIndex), columnIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        };
        this.myTable = new Table((javax.swing.table.TableModel)this.myTableModel);
        this.myTable.setSelectionMode(2);
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AddEditRemovePanel.this.doEdit();
                }
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddEditRemovePanel.this.updateButtons();
            }
        });
        return ScrollPaneFactory.createScrollPane(this.myTable);
    }

    @Override
    protected JButton[] createButtons() {
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEditRemovePanel.this.doAdd();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEditRemovePanel.this.doEdit();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEditRemovePanel.this.doRemove();
            }
        });
        return new JButton[]{this.myAddButton, this.myEditButton, this.myRemoveButton};
    }

    protected void doAdd() {
        T o = this.addItem();
        if (o == null) {
            return;
        }
        this.myData.add(o);
        int index = this.myData.size() - 1;
        this.myTableModel.fireTableRowsInserted(index, index);
        this.myTable.setRowSelectionInterval(index, index);
    }

    @Nullable
    protected abstract T addItem();

    protected abstract boolean removeItem(T var1);

    @Nullable
    protected abstract T editItem(T var1);

    protected void doEdit() {
        int selected = this.myTable.getSelectedRow();
        if (selected >= 0) {
            T o = this.editItem(this.myData.get(selected));
            if (o != null) {
                this.myData.set(selected, o);
            }
            this.myTableModel.fireTableRowsUpdated(selected, selected);
        }
    }

    protected void doRemove() {
        int idx;
        int i;
        int[] selected = this.myTable.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return;
        }
        for (i = selected.length - 1; i >= 0; --i) {
            idx = selected[i];
            if (!this.removeItem(this.myData.get(idx))) {
                return;
            }
            this.myData.remove(idx);
        }
        for (i = selected.length - 1; i >= 0; --i) {
            idx = selected[i];
            this.myTableModel.fireTableRowsDeleted(idx, idx);
        }
        int selection = selected[0];
        if (selection >= this.myData.size()) {
            selection = this.myData.size() - 1;
        }
        if (selection >= 0) {
            this.myTable.setRowSelectionInterval(selection, selection);
        }
    }

    public void setData(List<T> data) {
        this.myData = data;
        this.myTableModel.fireTableDataChanged();
    }

    public List<T> getData() {
        return this.myData;
    }

    public void setRenderer(int index, TableCellRenderer renderer) {
        this.myTable.getColumn(this.myModel.getColumnName(index)).setCellRenderer(renderer);
    }

    private void updateButtons() {
        this.myEditButton.setEnabled(this.myTable.getSelectedRowCount() == 1);
        this.myRemoveButton.setEnabled(this.myTable.getSelectedRowCount() >= 1);
    }

    public void setSelected(Object o) {
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            if (!this.myData.get(i).equals(o)) continue;
            this.myTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public JTable getTable() {
        return this.myTable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAddButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("button.add"));
        jPanel.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("button.edit"));
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.remove"));
        jPanel.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static abstract class TableModel<T> {
        public abstract int getColumnCount();

        public abstract String getColumnName(int var1);

        public abstract Object getField(T var1, int var2);

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isEditable(int column) {
            return false;
        }

        public void setValue(Object aValue, T data, int columnIndex) {
        }
    }
}

